/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.lang.reflect.Method;
import java.math.BigInteger;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMGetReceiptMojo;
import org.aion4j.maven.avm.mojo.AVMLocalRuntimeBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="contract-txn", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, aggregator=true)
public class AVMSendTxnMojo
extends AVMLocalRuntimeBaseMojo {
    private long defaultGas = 2000000L;
    private long defaultGasPrice = 100000000000L;
    private String contract;
    private String method;
    private String sender;
    private String methodArgs;
    private String value;
    private BigInteger valueB;

    @Override
    protected void preexecuteLocalAvm() throws MojoExecutionException {
    }

    @Override
    protected void executeLocalAvm(ClassLoader avmClassloader, Object localAvmInstance) throws MojoExecutionException {
        throw new MojoExecutionException("For local Avm mode, use aion4j:call goal to send transaction");
    }

    private void parseArgs() throws MojoExecutionException {
        Object[] args = new Object[5];
        this.contract = ConfigUtil.getProperty((String)"contract");
        this.sender = ConfigUtil.getProperty((String)"address");
        this.method = ConfigUtil.getProperty((String)"method");
        this.methodArgs = ConfigUtil.getProperty((String)"args");
        this.value = ConfigUtil.getProperty((String)"value");
        if (this.contract == null || this.contract.isEmpty()) {
            String lastDeployAddress = this.getCache().getLastDeployedAddress();
            if (lastDeployAddress == null || lastDeployAddress.isEmpty()) {
                this.getLog().error((CharSequence)"Contract address is missing. You need to deploy the contract first using aion4j:deploy.\n Also you can pass the contract address from commandline.");
                this.printHelp();
                throw new MojoExecutionException("Contract address is missing");
            }
            this.contract = lastDeployAddress;
            if (lastDeployAddress == null || lastDeployAddress.isEmpty()) {
                this.printHelp();
            }
        }
        if (this.method == null || this.method.isEmpty()) {
            this.getLog().error((CharSequence)"Method name is missing");
            this.printHelp();
            throw new MojoExecutionException("Method name is missing");
        }
        this.getLog().info((CharSequence)("Contract Address : " + this.contract));
        if (this.sender != null && this.getPrivateKey() == null) {
            this.getLog().info((CharSequence)("Sender Address   : " + this.sender));
        }
        this.getLog().info((CharSequence)("Method           : " + this.method));
        this.getLog().info((CharSequence)("Arguments        : " + this.methodArgs));
        this.valueB = this.value == null || this.value.isEmpty() ? BigInteger.ZERO : new BigInteger(this.value.trim());
    }

    private void printHelp() {
        this.getLog().info((CharSequence)"Usage:");
        this.getLog().info((CharSequence)"./mvnw  aion4j:contract-txn [-Dcontract=<contract_address>] [-Daddress=<sender_address>]  -Dmethod=<method_name> [-Dvalue=<value>] [-Dargs=<method_args>]");
        this.getLog().info((CharSequence)"Example:");
        this.getLog().info((CharSequence)"./mvnw aion4j:contract-txn -Dcontract=0x1122334455667788112233445566778811223344556677881122334455667788 -Daddress=0xa003ddd...  -Dmethod=transfer -Dargs=\"-A 0x1122334455667788112233445566778811223344556677881122334455667788 -J 100\"\n");
    }

    @Override
    protected void executeRemote() throws MojoExecutionException {
        long gasPrice;
        this.parseArgs();
        String web3RpcUrl = this.resolveWeb3rpcUrl();
        long gas = this.getGas();
        if (gas == 0L) {
            gas = this.defaultGas;
        }
        if ((gasPrice = this.getGasPrice()) == 0L) {
            gasPrice = this.defaultGasPrice;
        }
        try {
            Class localAvmClazz = this.getLocalAVMClass();
            Method enocodeCallMethodWithArgsStr = localAvmClazz.getMethod("encodeMethodCallWithArgsString", String.class, String.class);
            String encodedMethodCall = (String)enocodeCallMethodWithArgsStr.invoke(null, this.method, this.methodArgs);
            this.getLog().info((CharSequence)("Encoded method call data: " + encodedMethodCall));
            RemoteAVMNode remoteAVMNode = new RemoteAVMNode(web3RpcUrl, (Log)MavenLog.getLog(this.getLog()));
            String retData = null;
            String pk = this.getPrivateKey();
            retData = pk == null || pk.isEmpty() ? remoteAVMNode.sendTransaction(this.contract, this.sender, encodedMethodCall, this.valueB, gas, gasPrice) : remoteAVMNode.sendRawTransaction(this.contract, pk, encodedMethodCall, this.valueB, gas, gasPrice);
            if (retData != null && !retData.isEmpty()) {
                this.getCache().updateTxnReceipt(retData);
            }
            this.getLog().info((CharSequence)"****************  Contract Txn result  ****************");
            this.getLog().info((CharSequence)("Transaction receipt       :" + retData));
            this.getLog().info((CharSequence)"******************************************************");
            String wait = ConfigUtil.getProperty((String)"wait");
            boolean enableWait = false;
            if (wait != null && !wait.isEmpty() && Boolean.parseBoolean(wait)) {
                enableWait = true;
            }
            if (enableWait) {
                AVMGetReceiptMojo.startGetReceipt(web3RpcUrl, retData, "tail", "silent", this.getCache(), this.getLog());
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)String.format("Contract method transaction failed", new Object[0]), (Throwable)ex);
            throw new MojoExecutionException("Contract method transaction failed", ex);
        }
    }
}

