/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.math.BigInteger;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.aion4j.maven.avm.mojo.AVMGetReceiptMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="transfer", aggregator=true)
public class AVMTransferMojo
extends AVMBaseMojo {
    private long defaultGas = 2000000L;
    private long defaultGasPrice = 100000000000L;

    public void execute() throws MojoExecutionException, MojoFailureException {
        long gasPrice;
        if (this.isLocal()) {
            throw new MojoExecutionException("aion4j:transfer is only supported for remote Aion kernel");
        }
        String web3RpcUrl = this.resolveWeb3rpcUrl();
        long gas = this.getGas();
        if (gas == 0L) {
            gas = this.defaultGas;
        }
        if ((gasPrice = this.getGasPrice()) == 0L) {
            gasPrice = this.defaultGasPrice;
        }
        String from = ConfigUtil.getProperty((String)"from");
        String to = ConfigUtil.getProperty((String)"to");
        String value = ConfigUtil.getProperty((String)"value");
        String password = ConfigUtil.getProperty((String)"password");
        String pk = this.getPrivateKey();
        if ((pk == null || pk.isEmpty()) && (from == null || from.isEmpty())) {
            this.printHelp();
            throw new MojoExecutionException("Invalid args:  \"from\" property is missing");
        }
        if (to == null || to.isEmpty()) {
            this.printHelp();
            throw new MojoExecutionException("Invalid args: \"to\" property is missing");
        }
        if (value == null || value.isEmpty()) {
            this.printHelp();
            throw new MojoExecutionException("Invalid args: \"value\" property is missing");
        }
        BigInteger valueInAmp = BigInteger.ZERO;
        try {
            valueInAmp = new BigInteger(value.trim());
        }
        catch (NumberFormatException ex) {
            throw new MojoExecutionException("Invalid value or amount. " + value, (Exception)ex);
        }
        String txReceipt = null;
        RemoteAVMNode remoteAVMNode = new RemoteAVMNode(web3RpcUrl, (Log)MavenLog.getLog(this.getLog()));
        if (pk != null && !pk.isEmpty()) {
            txReceipt = remoteAVMNode.sendRawTransaction(to, pk, "", valueInAmp, gas, gasPrice);
        } else {
            if (password != null && !password.trim().isEmpty()) {
                remoteAVMNode.unlock(from, password);
            }
            txReceipt = remoteAVMNode.transfer(from, to, valueInAmp, gas, gasPrice);
        }
        if (txReceipt != null) {
            this.getLog().info((CharSequence)"Transfer successful");
            this.getLog().info((CharSequence)"****************  Transfer Txn result  ****************");
            this.getLog().info((CharSequence)("Transaction receipt       :" + txReceipt));
            this.getLog().info((CharSequence)"******************************************************");
            String wait = ConfigUtil.getProperty((String)"wait");
            boolean enableWait = false;
            if (wait != null && !wait.isEmpty() && Boolean.parseBoolean(wait)) {
                enableWait = true;
            }
            if (enableWait) {
                AVMGetReceiptMojo.startGetReceipt(web3RpcUrl, txReceipt, "tail", "silent", this.getCache(), this.getLog());
            }
        } else {
            this.getLog().error((CharSequence)"Transfer failed");
            throw new MojoExecutionException("Transfer failed");
        }
    }

    private void printHelp() {
        this.getLog().error((CharSequence)"Usage:");
        this.getLog().error((CharSequence)"mvn aion4j:transfer -Dweb3rpc.url=http://host:port -Dfrom=<address> -Dto=<address> -Dvalue=<Amount>");
    }
}

