/*
 * Decompiled with CFR 0.152.
 */
package com.nettgryppa.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class HashCash
implements Comparable<HashCash> {
    public static final int DefaultVersion = 1;
    private static final int hashLength = 160;
    private static final String dateFormatString = "yyMMdd";
    private static long milliFor16 = -1L;
    private String myToken;
    private int myValue;
    private Calendar myDate;
    private Map<String, List<String>> myExtensions;
    private int myVersion;
    private String myResource;

    public HashCash(String cash) throws NoSuchAlgorithmException {
        this.myToken = cash;
        String[] parts = cash.split(":");
        this.myVersion = Integer.parseInt(parts[0]);
        if (this.myVersion < 0 || this.myVersion > 1) {
            throw new IllegalArgumentException("Only supported versions are 0 and 1");
        }
        if (this.myVersion == 0 && parts.length != 6 || this.myVersion == 1 && parts.length != 7) {
            throw new IllegalArgumentException("Improperly formed HashCash");
        }
        try {
            int index = 1;
            this.myValue = this.myVersion == 1 ? Integer.parseInt(parts[index++]) : 0;
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
            Calendar tempCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            tempCal.setTime(dateFormat.parse(parts[index++]));
            this.myResource = parts[index++];
            this.myExtensions = HashCash.deserializeExtensions(parts[index++]);
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(cash.getBytes());
            byte[] tempBytes = md.digest();
            int tempValue = HashCash.numberOfLeadingZeros(tempBytes);
            if (this.myVersion == 0) {
                this.myValue = tempValue;
            } else if (this.myVersion == 1) {
                this.myValue = tempValue > this.myValue ? this.myValue : tempValue;
            }
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Improperly formed HashCash", ex);
        }
    }

    private HashCash() throws NoSuchAlgorithmException {
    }

    public static HashCash mintCash(String resource, int value) throws NoSuchAlgorithmException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        return HashCash.mintCash(resource, null, now, value, 1);
    }

    public static HashCash mintCash(String resource, int value, int version) throws NoSuchAlgorithmException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        return HashCash.mintCash(resource, null, now, value, version);
    }

    public static HashCash mintCash(String resource, Calendar date, int value) throws NoSuchAlgorithmException {
        return HashCash.mintCash(resource, null, date, value, 1);
    }

    public static HashCash mintCash(String resource, Calendar date, int value, int version) throws NoSuchAlgorithmException {
        return HashCash.mintCash(resource, null, date, value, version);
    }

    public static HashCash mintCash(String resource, Map<String, List<String>> extensions, int value) throws NoSuchAlgorithmException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        return HashCash.mintCash(resource, extensions, now, value, 1);
    }

    public static HashCash mintCash(String resource, Map<String, List<String>> extensions, int value, int version) throws NoSuchAlgorithmException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        return HashCash.mintCash(resource, extensions, now, value, version);
    }

    public static HashCash mintCash(String resource, Map<String, List<String>> extensions, Calendar date, int value) throws NoSuchAlgorithmException {
        return HashCash.mintCash(resource, extensions, date, value, 1);
    }

    public static HashCash mintCash(String resource, Map<String, List<String>> extensions, Calendar date, int value, int version) throws NoSuchAlgorithmException {
        if (version < 0 || version > 1) {
            throw new IllegalArgumentException("Only supported versions are 0 and 1");
        }
        if (value < 0 || value > 160) {
            throw new IllegalArgumentException("Value must be between 0 and 160");
        }
        if (resource.contains(":")) {
            throw new IllegalArgumentException("Resource may not contain a colon.");
        }
        HashCash result = new HashCash();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        result.myResource = resource;
        result.myExtensions = null == extensions ? new HashMap<String, List<String>>() : extensions;
        result.myDate = date;
        result.myVersion = version;
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
        switch (version) {
            case 0: {
                String prefix = version + ":" + dateFormat.format(date.getTime()) + ":" + resource + ":" + HashCash.serializeExtensions(extensions) + ":";
                result.myToken = HashCash.generateCash(prefix, value, md);
                md.reset();
                md.update(result.myToken.getBytes());
                result.myValue = HashCash.numberOfLeadingZeros(md.digest());
                break;
            }
            case 1: {
                result.myValue = value;
                String prefix = version + ":" + value + ":" + dateFormat.format(date.getTime()) + ":" + resource + ":" + HashCash.serializeExtensions(extensions) + ":";
                result.myToken = HashCash.generateCash(prefix, value, md);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only supported versions are 0 and 1");
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HashCash) {
            return this.toString().equals(obj.toString());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.myToken;
    }

    public Map<String, List<String>> getExtensions() {
        return this.myExtensions;
    }

    public String getResource() {
        return this.myResource;
    }

    public Calendar getDate() {
        return this.myDate;
    }

    public int getValue() {
        return this.myValue;
    }

    public int getVersion() {
        return this.myVersion;
    }

    private static String generateCash(String prefix, int value, MessageDigest md) throws NoSuchAlgorithmException {
        String temp;
        int tempValue;
        SecureRandom rnd = SecureRandom.getInstance("SHA1PRNG");
        byte[] tmpBytes = new byte[4];
        rnd.nextBytes(tmpBytes);
        long random = HashCash.unsignedIntToLong(tmpBytes);
        rnd.nextBytes(tmpBytes);
        long counter = HashCash.unsignedIntToLong(tmpBytes);
        prefix = (String)prefix + Long.toHexString(random) + ":";
        do {
            temp = (String)prefix + Long.toHexString(++counter);
            md.reset();
            md.update(temp.getBytes());
            byte[] bArray = md.digest();
            tempValue = HashCash.numberOfLeadingZeros(bArray);
            if (counter % 300000L != 0L) continue;
            System.out.print(".");
        } while (tempValue < value);
        System.out.println("Done");
        return temp;
    }

    private static long unsignedIntToLong(byte[] b) {
        long l = 0L;
        l |= (long)(b[0] & 0xFF);
        l <<= 8;
        l |= (long)(b[1] & 0xFF);
        l <<= 8;
        l |= (long)(b[2] & 0xFF);
        l <<= 8;
        return l |= (long)(b[3] & 0xFF);
    }

    private static String serializeExtensions(Map<String, List<String>> extensions) {
        if (null == extensions || extensions.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (String key : extensions.keySet()) {
            if (key.contains(":") || key.contains(";") || key.contains("=")) {
                throw new IllegalArgumentException("Extension key contains an illegal character. " + key);
            }
            if (!first) {
                result.append(";");
            }
            first = false;
            result.append(key);
            List<String> tempList = extensions.get(key);
            if (null == tempList) continue;
            result.append("=");
            for (int i = 0; i < tempList.size(); ++i) {
                if (tempList.get(i).contains(":") || tempList.get(i).contains(";") || tempList.get(i).contains(",")) {
                    throw new IllegalArgumentException("Extension value contains an illegal character. " + tempList.get(i));
                }
                if (i > 0) {
                    result.append(",");
                }
                result.append(tempList.get(i));
            }
        }
        return result.toString();
    }

    private static Map<String, List<String>> deserializeExtensions(String extensions) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (null == extensions || extensions.length() == 0) {
            return result;
        }
        String[] items = extensions.split(";");
        for (int i = 0; i < items.length; ++i) {
            String[] parts = items[i].split("=", 2);
            if (parts.length == 1) {
                result.put(parts[0], null);
                continue;
            }
            result.put(parts[0], Arrays.asList(parts[1].split(",")));
        }
        return result;
    }

    private static int numberOfLeadingZeros(byte[] values) {
        int result = 0;
        int temp = 0;
        for (int i = 0; i < values.length; ++i) {
            temp = HashCash.numberOfLeadingZeros(values[i]);
            result += temp;
            if (temp != 8) break;
        }
        return result;
    }

    private static int numberOfLeadingZeros(byte value) {
        if (value < 0) {
            return 0;
        }
        if (value < 1) {
            return 8;
        }
        if (value < 2) {
            return 7;
        }
        if (value < 4) {
            return 6;
        }
        if (value < 8) {
            return 5;
        }
        if (value < 16) {
            return 4;
        }
        if (value < 32) {
            return 3;
        }
        if (value < 64) {
            return 2;
        }
        if (value < 128) {
            return 1;
        }
        return 0;
    }

    public static long estimateTime(int value) throws NoSuchAlgorithmException {
        HashCash.initEstimates();
        return (long)((double)milliFor16 * Math.pow(2.0, value - 16));
    }

    public static int estimateValue(int secs) throws NoSuchAlgorithmException {
        HashCash.initEstimates();
        int result = 0;
        long millis = secs * 1000 * 65536;
        millis /= milliFor16;
        while (millis > 1L) {
            ++result;
            millis /= 2L;
        }
        return result;
    }

    private static void initEstimates() throws NoSuchAlgorithmException {
        if (milliFor16 == -1L) {
            long duration = Calendar.getInstance().getTimeInMillis();
            for (int i = 0; i < 11; ++i) {
                HashCash.mintCash("estimation", 16);
            }
            duration = Calendar.getInstance().getTimeInMillis() - duration;
            milliFor16 = duration / 10L;
        }
    }

    @Override
    public int compareTo(HashCash other) {
        if (null == other) {
            throw new NullPointerException();
        }
        return Integer.valueOf(this.getValue()).compareTo(other.getValue());
    }
}

