/*
 * Decompiled with CFR 0.152.
 */
package org.aion.rlp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.aion.base.util.ByteUtil;
import org.aion.rlp.Utils;

public class CompactEncoder {
    private static final byte TERMINATOR = 16;
    private static final Map<Character, Byte> hexMap = new HashMap<Character, Byte>();

    public static byte[] packNibbles(byte[] nibbles) {
        int start;
        int terminator = 0;
        if (nibbles.length > 0 && nibbles[nibbles.length - 1] == 16) {
            terminator = 1;
        }
        int oddlen = (nibbles.length - terminator) % 2;
        int flag2 = 2 * terminator + oddlen;
        int len = terminator == 0 ? nibbles.length : nibbles.length - 1;
        byte[] output = new byte[len / 2 + 1];
        if (oddlen != 0) {
            output[0] = (byte)(16 * flag2 + nibbles[0]);
            start = 1;
        } else {
            output[0] = (byte)(16 * flag2);
            start = 0;
        }
        int i = start;
        int index = 1;
        while (i < len) {
            output[index] = (byte)(16 * nibbles[i] + nibbles[i + 1]);
            i += 2;
            ++index;
        }
        return output;
    }

    public static boolean hasTerminator(byte[] packedKey) {
        return (packedKey[0] >> 4 & 2) != 0;
    }

    public static byte[] unpackToNibbles(byte[] str) {
        byte[] base = CompactEncoder.binToNibbles(str);
        if ((base = Arrays.copyOf(base, base.length - 1))[0] >= 2) {
            base = ByteUtil.appendByte(base, (byte)16);
        }
        base = base[0] % 2 == 1 ? Arrays.copyOfRange(base, 1, base.length) : Arrays.copyOfRange(base, 2, base.length);
        return base;
    }

    public static byte[] binToNibbles(byte[] str) {
        byte[] hexEncodedTerminated = Utils.hexEncode(str, true);
        CompactEncoder.update(hexEncodedTerminated, hexEncodedTerminated.length - 1);
        hexEncodedTerminated[hexEncodedTerminated.length - 1] = 16;
        return hexEncodedTerminated;
    }

    public static byte[] binToNibblesNoTerminator(byte[] str) {
        byte[] hexEncoded = Utils.hexEncode(str);
        CompactEncoder.update(hexEncoded, hexEncoded.length);
        return hexEncoded;
    }

    private static void update(byte[] hexEncoded, int length) {
        for (int i = 0; i < length; ++i) {
            byte b = hexEncoded[i];
            hexEncoded[i] = hexMap.get(Character.valueOf((char)b));
        }
    }

    static {
        hexMap.put(Character.valueOf('0'), (byte)0);
        hexMap.put(Character.valueOf('1'), (byte)1);
        hexMap.put(Character.valueOf('2'), (byte)2);
        hexMap.put(Character.valueOf('3'), (byte)3);
        hexMap.put(Character.valueOf('4'), (byte)4);
        hexMap.put(Character.valueOf('5'), (byte)5);
        hexMap.put(Character.valueOf('6'), (byte)6);
        hexMap.put(Character.valueOf('7'), (byte)7);
        hexMap.put(Character.valueOf('8'), (byte)8);
        hexMap.put(Character.valueOf('9'), (byte)9);
        hexMap.put(Character.valueOf('a'), (byte)10);
        hexMap.put(Character.valueOf('b'), (byte)11);
        hexMap.put(Character.valueOf('c'), (byte)12);
        hexMap.put(Character.valueOf('d'), (byte)13);
        hexMap.put(Character.valueOf('e'), (byte)14);
        hexMap.put(Character.valueOf('f'), (byte)15);
    }
}

