/*
 * Decompiled with CFR 0.152.
 */
package org.aion.rlp;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aion.base.util.ByteUtil;
import org.aion.base.util.Hex;
import org.aion.rlp.DecodeResult;
import org.aion.rlp.RLPElement;
import org.aion.rlp.RLPItem;
import org.aion.rlp.RLPList;
import org.aion.rlp.Utils;
import org.aion.rlp.Value;

public class RLP {
    private static final int SIZE_THRESHOLD = 56;
    private static final int OFFSET_SHORT_ITEM = 128;
    private static final int OFFSET_LONG_ITEM = 183;
    private static final int OFFSET_SHORT_LIST = 192;
    private static final int OFFSET_LONG_LIST = 247;

    public static int decodeInt(byte[] data, int index) {
        int value = 0;
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) >= 128 && (data[index] & 0xFF) < 183) {
            int length = data[index] - 128;
            byte pow = (byte)(length - 1);
            for (int i = 1; i <= length; ++i) {
                value += (data[index + i] & 0xFF) << 8 * pow;
                pow = (byte)(pow - 1);
            }
        } else {
            throw new RuntimeException("wrong decode attempt");
        }
        return value;
    }

    public static BigInteger decodeBigInteger(byte[] data, int index) {
        int prefix = data[index] & 0xFF;
        if (prefix < 128) {
            return BigInteger.valueOf(data[index]);
        }
        if (prefix <= 183) {
            int length = prefix - 128;
            byte[] copy = new byte[length];
            System.arraycopy(data, index + 1, copy, 0, Math.min(data.length - index - 1, length));
            return new BigInteger(1, copy);
        }
        if (prefix < 192) {
            int lengthOfLength = prefix - 183;
            byte[] copy = new byte[lengthOfLength];
            System.arraycopy(data, index + 1, copy, 0, Math.min(data.length - index - 1, lengthOfLength));
            int length = new BigInteger(1, copy).intValue();
            copy = new byte[length];
            System.arraycopy(data, index + 1 + lengthOfLength, copy, 0, Math.min(data.length - index - 1 - lengthOfLength, length));
            return new BigInteger(1, copy);
        }
        throw new RuntimeException("wrong decode attempt");
    }

    private static int calcLength(int lengthOfLength, byte[] msgData, int pos) {
        byte pow = (byte)(lengthOfLength - 1);
        int length = 0;
        for (int i = 1; i <= lengthOfLength; ++i) {
            length += (msgData[pos + i] & 0xFF) << 8 * pow;
            pow = (byte)(pow - 1);
        }
        return length;
    }

    public static RLPList decode2(byte[] msgData) {
        RLPList rlpList = new RLPList();
        RLP.fullTraverse(msgData, 0, 0, msgData == null ? 0 : msgData.length, rlpList);
        return rlpList;
    }

    public static RLPElement decode2OneItem(byte[] msgData, int startPos) {
        RLPList rlpList = new RLPList();
        RLP.fullTraverse(msgData, 0, startPos, startPos + 1, rlpList);
        return (RLPElement)rlpList.get(0);
    }

    private static void fullTraverse(byte[] msgData, int level, int startPos, int endPos, RLPList rlpList) {
        try {
            if (msgData == null || msgData.length == 0) {
                return;
            }
            int pos = startPos;
            while (pos < endPos) {
                if ((msgData[pos] & 0xFF) > 247) {
                    byte lengthOfLength = (byte)(msgData[pos] - 247);
                    int length = RLP.calcLength(lengthOfLength, msgData, pos);
                    byte[] rlpData = new byte[lengthOfLength + length + 1];
                    System.arraycopy(msgData, pos, rlpData, 0, lengthOfLength + length + 1);
                    RLPList newLevelList = new RLPList();
                    newLevelList.setRLPData(rlpData);
                    RLP.fullTraverse(msgData, level + 1, pos + lengthOfLength + 1, pos + lengthOfLength + length + 1, newLevelList);
                    rlpList.add(newLevelList);
                    pos += lengthOfLength + length + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 192 && (msgData[pos] & 0xFF) <= 247) {
                    byte length = (byte)((msgData[pos] & 0xFF) - 192);
                    byte[] rlpData = new byte[length + 1];
                    System.arraycopy(msgData, pos, rlpData, 0, length + 1);
                    RLPList newLevelList = new RLPList();
                    newLevelList.setRLPData(rlpData);
                    if (length > 0) {
                        RLP.fullTraverse(msgData, level + 1, pos + 1, pos + length + 1, newLevelList);
                    }
                    rlpList.add(newLevelList);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) > 183 && (msgData[pos] & 0xFF) < 192) {
                    byte lengthOfLength = (byte)(msgData[pos] - 183);
                    int length = RLP.calcLength(lengthOfLength, msgData, pos);
                    byte[] item = new byte[length];
                    System.arraycopy(msgData, pos + lengthOfLength + 1, item, 0, length);
                    RLPItem rlpItem = new RLPItem(item);
                    rlpList.add(rlpItem);
                    pos += lengthOfLength + length + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) > 128 && (msgData[pos] & 0xFF) <= 183) {
                    byte length = (byte)((msgData[pos] & 0xFF) - 128);
                    byte[] item = new byte[length];
                    System.arraycopy(msgData, pos + 1, item, 0, length);
                    RLPItem rlpItem = new RLPItem(item);
                    rlpList.add(rlpItem);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) == 128) {
                    RLPItem rlpItem = new RLPItem(ByteUtil.EMPTY_BYTE_ARRAY);
                    rlpList.add(rlpItem);
                    ++pos;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 128) continue;
                byte[] item = new byte[]{(byte)(msgData[pos] & 0xFF)};
                RLPItem rlpItem = new RLPItem(item);
                rlpList.add(rlpItem);
                ++pos;
            }
        }
        catch (Exception e) {
            int length = endPos - startPos;
            if (length > 4096) {
                length = 4096;
            }
            throw new RuntimeException("RLP wrong encoding (" + Hex.toHexString(msgData, startPos, length) + ")", e);
        }
        catch (OutOfMemoryError e) {
            int length = endPos - startPos;
            if (length > 4096) {
                length = 4096;
            }
            throw new RuntimeException("Invalid RLP (excessive mem allocation while parsing) (" + Hex.toHexString(msgData, startPos, length) + ")", e);
        }
    }

    public static DecodeResult decode(byte[] data, int pos) {
        if (data == null || data.length < 1) {
            return null;
        }
        int prefix = data[pos] & 0xFF;
        if (prefix == 128) {
            return new DecodeResult(pos + 1, "");
        }
        if (prefix < 128) {
            return new DecodeResult(pos + 1, new byte[]{data[pos]});
        }
        if (prefix <= 183) {
            int len = prefix - 128;
            return new DecodeResult(pos + 1 + len, Arrays.copyOfRange(data, pos + 1, pos + 1 + len));
        }
        if (prefix < 192) {
            int lenlen = prefix - 183;
            int lenbytes = ByteUtil.byteArrayToInt(Arrays.copyOfRange(data, pos + 1, pos + 1 + lenlen));
            return new DecodeResult(pos + 1 + lenlen + lenbytes, Arrays.copyOfRange(data, pos + 1 + lenlen, pos + 1 + lenlen + lenbytes));
        }
        if (prefix <= 247) {
            int len = prefix - 192;
            return RLP.decodeList(data, ++pos, len);
        }
        if (prefix < 255) {
            int lenlen = prefix - 247;
            int lenlist = ByteUtil.byteArrayToInt(Arrays.copyOfRange(data, pos + 1, pos + 1 + lenlen));
            pos = pos + lenlen + 1;
            return RLP.decodeList(data, pos, lenlist);
        }
        throw new RuntimeException("Only byte values between 0x00 and 0xFF are supported, but got: " + prefix);
    }

    private static DecodeResult decodeList(byte[] data, int pos, int len) {
        int prevPos;
        ArrayList<Object> slice = new ArrayList<Object>();
        for (int i = 0; i < len; i += prevPos - pos) {
            DecodeResult result = RLP.decode(data, pos);
            slice.add(result.getDecoded());
            prevPos = result.getPos();
            pos = prevPos;
        }
        return new DecodeResult(pos, slice.toArray());
    }

    public static byte[] encode(Object input) {
        Value val = new Value(input);
        if (val.isList()) {
            List<Object> inputArray = val.asList();
            if (inputArray.isEmpty()) {
                return RLP.encodeLength(inputArray.size(), 192);
            }
            ArrayList<byte[]> obj = new ArrayList<byte[]>();
            int length = 0;
            for (Object object : inputArray) {
                byte[] temp = RLP.encode(object);
                obj.add(temp);
                length += temp.length;
            }
            byte[] prefix = RLP.encodeLength(length, 192);
            byte[] output = new byte[prefix.length + length];
            System.arraycopy(prefix, 0, output, 0, prefix.length);
            int pos = prefix.length;
            for (byte[] anObj : obj) {
                System.arraycopy(anObj, 0, output, pos, anObj.length);
                pos += anObj.length;
            }
            return output;
        }
        byte[] inputAsBytes = RLP.toBytes(input);
        if (inputAsBytes.length == 1 && (inputAsBytes[0] & 0xFF) < 128) {
            return inputAsBytes;
        }
        byte[] firstByte = RLP.encodeLength(inputAsBytes.length, 128);
        return Utils.concatenate(firstByte, inputAsBytes);
    }

    public static byte[] encodeLength(int length, int offset) {
        if (length < 56) {
            byte firstByte = (byte)(length + offset);
            return new byte[]{firstByte};
        }
        byte[] binaryLength = length > 255 ? ByteUtil.intToBytesNoLeadZeroes(length) : new byte[]{(byte)length};
        byte firstByte = (byte)(binaryLength.length + offset + 56 - 1);
        return Utils.concatenate(new byte[]{firstByte}, binaryLength);
    }

    public static byte[] encodeByte(byte singleByte) {
        if ((singleByte & 0xFF) == 0) {
            return new byte[]{-128};
        }
        if ((singleByte & 0xFF) <= 127) {
            return new byte[]{singleByte};
        }
        return new byte[]{-127, singleByte};
    }

    public static byte[] encodeShort(short singleShort) {
        if ((singleShort & 0xFF) == singleShort) {
            return RLP.encodeByte((byte)singleShort);
        }
        return new byte[]{-126, (byte)(singleShort >> 8 & 0xFF), (byte)(singleShort & 0xFF)};
    }

    public static byte[] encodeInt(int singleInt) {
        if ((singleInt & 0xFFFF) == singleInt) {
            return RLP.encodeShort((short)singleInt);
        }
        if ((singleInt & 0xFFFFFF) == singleInt) {
            return new byte[]{-125, (byte)(singleInt >>> 16), (byte)(singleInt >>> 8), (byte)singleInt};
        }
        return new byte[]{-124, (byte)(singleInt >>> 24), (byte)(singleInt >>> 16), (byte)(singleInt >>> 8), (byte)singleInt};
    }

    public static byte[] encodeLong(long l) {
        if ((l & 0xFFFFFFFFL) == l) {
            return RLP.encodeInt((int)l);
        }
        byte[] out = new byte[9];
        out[0] = -120;
        for (int i = 8; i > 0; --i) {
            out[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return out;
    }

    public static byte[] encodeString(String srcString) {
        return RLP.encodeElement(srcString.getBytes());
    }

    public static byte[] encodeBigInteger(BigInteger srcBigInteger) {
        if (srcBigInteger.equals(BigInteger.ZERO)) {
            return RLP.encodeByte((byte)0);
        }
        return RLP.encodeElement(Utils.asUnsignedByteArray(srcBigInteger));
    }

    public static byte[] encodeElement(byte[] srcData) {
        if (ByteUtil.isNullOrZeroArray(srcData)) {
            return new byte[]{-128};
        }
        if (ByteUtil.isSingleZero(srcData)) {
            return srcData;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return srcData;
        }
        if (srcData.length < 56) {
            byte length = (byte)(128 + srcData.length);
            byte[] data = new byte[srcData.length + 1];
            System.arraycopy(srcData, 0, data, 1, srcData.length);
            data[0] = length;
            return data;
        }
        int byteNum = 0;
        for (int tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        byte[] data = new byte[srcData.length + 1 + byteNum];
        data[0] = (byte)(183 + byteNum);
        for (int i = 0; i < byteNum; ++i) {
            data[byteNum - i] = (byte)(srcData.length >> 8 * i & 0xFF);
        }
        System.arraycopy(srcData, 0, data, 1 + byteNum, srcData.length);
        return data;
    }

    public static int calcElementPrefixSize(byte[] srcData) {
        if (ByteUtil.isNullOrZeroArray(srcData)) {
            return 0;
        }
        if (ByteUtil.isSingleZero(srcData)) {
            return 0;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return 0;
        }
        if (srcData.length < 56) {
            return 1;
        }
        int byteNum = 0;
        for (int tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        return 1 + byteNum;
    }

    public static byte[] encodeListHeader(int size) {
        byte[] header;
        if (size == 0) {
            return new byte[]{-64};
        }
        if (size < 56) {
            header = new byte[]{(byte)(192 + size)};
        } else {
            int byteNum = 0;
            for (int tmpLength = size; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            header = new byte[1 + byteNum];
            header[0] = (byte)(247 + byteNum);
            for (int i = 0; i < byteNum; ++i) {
                header[byteNum - i] = (byte)(size >> 8 * i & 0xFF);
            }
        }
        return header;
    }

    public static byte[] encodeLongElementHeader(int length) {
        if (length < 56) {
            if (length == 0) {
                return new byte[]{-128};
            }
            return new byte[]{(byte)(128 + length)};
        }
        int byteNum = 0;
        for (int tmpLength = length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        byte[] header = new byte[1 + byteNum];
        header[0] = (byte)(183 + byteNum);
        for (int i = 0; i < byteNum; ++i) {
            header[byteNum - i] = (byte)(length >> 8 * i & 0xFF);
        }
        return header;
    }

    public static byte[] encodeList(byte[] ... elements) {
        int copyPos;
        byte[] data;
        if (elements == null) {
            return new byte[]{-64};
        }
        int totalLength = 0;
        for (byte[] element1 : elements) {
            totalLength += element1.length;
        }
        if (totalLength < 56) {
            data = new byte[1 + totalLength];
            data[0] = (byte)(192 + totalLength);
            copyPos = 1;
        } else {
            int byteNum = 0;
            for (int tmpLength = totalLength; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            data = new byte[1 + byteNum + totalLength];
            data[0] = (byte)(247 + byteNum);
            for (int i = 0; i < byteNum; ++i) {
                data[byteNum - i] = (byte)(totalLength >> 8 * i & 0xFF);
            }
            copyPos = byteNum + 1;
        }
        for (byte[] element : elements) {
            System.arraycopy(element, 0, data, copyPos, element.length);
            copyPos += element.length;
        }
        return data;
    }

    private static byte[] toBytes(Object input) {
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input instanceof String) {
            String inputString = (String)input;
            return inputString.getBytes();
        }
        if (input instanceof Byte) {
            Byte inputByte = (Byte)input;
            return inputByte == 0 ? ByteUtil.EMPTY_BYTE_ARRAY : Utils.asUnsignedByteArray(BigInteger.valueOf(inputByte.byteValue()));
        }
        if (input instanceof Short) {
            Short inputShort = (Short)input;
            return inputShort == 0 ? ByteUtil.EMPTY_BYTE_ARRAY : Utils.asUnsignedByteArray(BigInteger.valueOf(inputShort.shortValue()));
        }
        if (input instanceof Integer) {
            Integer inputInt = (Integer)input;
            return inputInt == 0 ? ByteUtil.EMPTY_BYTE_ARRAY : Utils.asUnsignedByteArray(BigInteger.valueOf(inputInt.intValue()));
        }
        if (input instanceof Long) {
            Long inputLong = (Long)input;
            return inputLong == 0L ? ByteUtil.EMPTY_BYTE_ARRAY : Utils.asUnsignedByteArray(BigInteger.valueOf(inputLong));
        }
        if (input instanceof BigInteger) {
            BigInteger inputBigInt = (BigInteger)input;
            return inputBigInt.equals(BigInteger.ZERO) ? ByteUtil.EMPTY_BYTE_ARRAY : Utils.asUnsignedByteArray(inputBigInt);
        }
        if (input instanceof Value) {
            Value val = (Value)input;
            return RLP.toBytes(val.asObj());
        }
        throw new RuntimeException("Unsupported type " + input.getClass().getSimpleName() + ". Only accepting String, Byte, Short, Integer, Long and BigInteger for now.");
    }
}

