/*
 * Decompiled with CFR 0.152.
 */
package org.aion.rlp;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.aion.base.util.ByteUtil;
import org.aion.base.util.Hex;
import org.aion.rlp.CompactEncoder;
import org.aion.rlp.RLP;

public class Value {
    private Object value;
    private byte[] rlp;
    private boolean decoded = false;

    public static Value fromRlpEncoded(byte[] data) {
        if (data != null && data.length != 0) {
            Value v = new Value();
            v.init(data);
            return v;
        }
        return null;
    }

    private Value() {
    }

    private void init(byte[] rlp) {
        this.rlp = rlp;
    }

    public Value(Object obj) {
        this.decoded = true;
        if (obj == null) {
            return;
        }
        this.value = obj instanceof Value ? ((Value)obj).asObj() : obj;
    }

    public Object asObj() {
        this.decode();
        return this.value;
    }

    public List<Object> asList() {
        this.decode();
        Object[] valueArray = (Object[])this.value;
        return Arrays.asList(valueArray);
    }

    public int asInt() {
        this.decode();
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        if (this.isBytes()) {
            return new BigInteger(1, this.asBytes()).intValue();
        }
        return 0;
    }

    public long asLong() {
        this.decode();
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        if (this.isBytes()) {
            return new BigInteger(1, this.asBytes()).longValue();
        }
        return 0L;
    }

    public BigInteger asBigInt() {
        this.decode();
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        if (this.isBytes()) {
            return new BigInteger(1, this.asBytes());
        }
        if (this.value instanceof Byte) {
            return BigInteger.valueOf(((Byte)this.value).byteValue());
        }
        if (this.value instanceof Short) {
            return BigInteger.valueOf(((Short)this.value).shortValue());
        }
        if (this.value instanceof Integer) {
            return BigInteger.valueOf(((Integer)this.value).intValue());
        }
        if (this.value instanceof Long) {
            return BigInteger.valueOf((Long)this.value);
        }
        return BigInteger.ZERO;
    }

    public String asString() {
        this.decode();
        if (this.isBytes()) {
            return new String((byte[])this.value);
        }
        if (this.isString()) {
            return (String)this.value;
        }
        return "";
    }

    public byte[] asBytes() {
        this.decode();
        if (this.isBytes()) {
            return (byte[])this.value;
        }
        if (this.isString()) {
            return this.asString().getBytes();
        }
        return ByteUtil.EMPTY_BYTE_ARRAY;
    }

    public byte[] getData() {
        return this.encode();
    }

    public Value get(int index) {
        if (this.isList()) {
            if (this.asList().size() <= index) {
                return new Value(null);
            }
            if (index < 0) {
                throw new RuntimeException("Negative index not allowed");
            }
            return new Value(this.asList().get(index));
        }
        return new Value(null);
    }

    private void decode() {
        if (!this.decoded) {
            this.value = RLP.decode(this.rlp, 0).getDecoded();
            this.decoded = true;
        }
    }

    public byte[] encode() {
        if (this.rlp == null) {
            this.rlp = RLP.encode(this.value);
        }
        return this.rlp;
    }

    public boolean cmp(Value o) {
        if (o == null) {
            return false;
        }
        if (this.rlp != null && o.rlp != null) {
            return Arrays.equals(this.rlp, o.rlp);
        }
        return Arrays.equals(this.encode(), o.encode());
    }

    public boolean isList() {
        this.decode();
        return this.value != null && this.value.getClass().isArray() && !this.value.getClass().getComponentType().isPrimitive();
    }

    public boolean isString() {
        this.decode();
        return this.value instanceof String;
    }

    public boolean isBytes() {
        this.decode();
        return this.value instanceof byte[];
    }

    private boolean isReadableString() {
        this.decode();
        int readableChars = 0;
        byte[] data = (byte[])this.value;
        if (data.length == 1 && data[0] > 31 && data[0] < 126) {
            return true;
        }
        for (byte aData : data) {
            if (aData <= 32 || aData >= 126) continue;
            ++readableChars;
        }
        return (double)readableChars / (double)data.length > 0.55;
    }

    public boolean isHashCode() {
        this.decode();
        return this.asBytes().length == 32;
    }

    public boolean isNull() {
        this.decode();
        return this.value == null;
    }

    private boolean isEmpty() {
        this.decode();
        return this.isNull() || this.isBytes() && this.asBytes().length == 0 || this.isList() && this.asList().isEmpty() || this.isString() && this.asString().isEmpty();
    }

    public int length() {
        this.decode();
        if (this.isList()) {
            return this.asList().size();
        }
        if (this.isBytes()) {
            return this.asBytes().length;
        }
        if (this.isString()) {
            return this.asString().length();
        }
        return 0;
    }

    public String toString() {
        this.decode();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isList()) {
            Object[] list = (Object[])this.value;
            if (list.length == 2) {
                stringBuilder.append("[ ");
                Value key = new Value(list[0]);
                byte[] keyNibbles = CompactEncoder.binToNibblesNoTerminator(key.asBytes());
                String keyString = ByteUtil.nibblesToPrettyString(keyNibbles);
                stringBuilder.append(keyString);
                stringBuilder.append(",");
                Value val = new Value(list[1]);
                stringBuilder.append(val.toString());
                stringBuilder.append(" ]");
                return stringBuilder.toString();
            }
            stringBuilder.append(" [");
            for (int i = 0; i < list.length; ++i) {
                Value val = new Value(list[i]);
                if (val.isString() || val.isEmpty()) {
                    stringBuilder.append("'").append(val.toString()).append("'");
                } else {
                    stringBuilder.append(val.toString());
                }
                if (i >= list.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("] ");
            return stringBuilder.toString();
        }
        if (this.isEmpty()) {
            return "";
        }
        if (this.isBytes()) {
            StringBuilder output = new StringBuilder();
            if (this.isHashCode()) {
                output.append(Hex.toHexString(this.asBytes()));
            } else if (this.isReadableString()) {
                output.append("'");
                for (byte oneByte : this.asBytes()) {
                    if (oneByte < 16) {
                        output.append("\\x").append(ByteUtil.oneByteToHexString(oneByte));
                        continue;
                    }
                    output.append(Character.valueOf((char)oneByte));
                }
                output.append("'");
                return output.toString();
            }
            return Hex.toHexString(this.asBytes());
        }
        if (this.isString()) {
            return this.asString();
        }
        return "Unexpected type";
    }
}

