/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.cache.global;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class FileEncrypterDecrypter {
    private SecretKey secretKey;
    private Cipher cipher = null;

    public FileEncrypterDecrypter(SecretKey secretKey) throws NoSuchPaddingException, NoSuchAlgorithmException {
        this.secretKey = secretKey;
        this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    public void encrypt(String content, String fileName) throws InvalidKeyException, IOException {
        this.cipher.init(1, this.secretKey);
        byte[] iv = this.cipher.getIV();
        try (FileOutputStream fileOut = new FileOutputStream(fileName);
             CipherOutputStream cipherOut = new CipherOutputStream(fileOut, this.cipher);){
            fileOut.write(iv);
            cipherOut.write(content.getBytes());
        }
    }

    public String decrypt(File file) throws InvalidAlgorithmParameterException, InvalidKeyException, IOException {
        String content;
        try (FileInputStream fileIn = new FileInputStream(file);){
            byte[] fileIv = new byte[16];
            fileIn.read(fileIv);
            this.cipher.init(2, (Key)this.secretKey, new IvParameterSpec(fileIv));
            try (CipherInputStream cipherIn = new CipherInputStream(fileIn, this.cipher);
                 InputStreamReader inputReader = new InputStreamReader(cipherIn);
                 BufferedReader reader = new BufferedReader(inputReader);){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                content = sb.toString();
            }
        }
        return content;
    }

    public static String generateKey() throws NoSuchAlgorithmException {
        SecretKey secretKey = KeyGenerator.getInstance("AES").generateKey();
        String encodedKey = Base64.getEncoder().encodeToString(secretKey.getEncoded());
        return encodedKey;
    }

    public static SecretKey getSecretKeyFromEncodedKey(String encodedKey) {
        byte[] decodedKey = Base64.getDecoder().decode(encodedKey);
        SecretKeySpec originalKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        return originalKey;
    }
}

