/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.cache.global;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.cache.global.AccountCache;
import org.aion4j.avm.helper.cache.global.FileEncrypterDecrypter;
import org.aion4j.avm.helper.util.StringUtils;

public class GlobalCache {
    public static String ACCOUNT_CACHE = ".aion4j.account.conf";
    private static final String SECRET_KEY = "secret-key";
    private static final String PROTECTION_MODE = "protection-mode";
    private final String targetFolder;
    private Log log;
    private ObjectMapper objectMapper;

    public GlobalCache(String targetFolder, Log log) {
        this.targetFolder = targetFolder;
        this.log = log;
        this.objectMapper = new ObjectMapper();
    }

    public void setAccountCache(AccountCache accountCache) {
        File file = this.getAccountCacheFile();
        SecretKey secretKey = this.getSecretKeyFromFile();
        if (secretKey == null) {
            secretKey = this.generateNewSecretAndStore();
        }
        if (secretKey == null) {
            this.getAccountCacheKeyFile().delete();
            this.writeAccountCacheToFile(accountCache, file);
        } else {
            try {
                String jsonContent = this.writeAccountCacheToJson(accountCache);
                FileEncrypterDecrypter fileEncrypterDecrypter = new FileEncrypterDecrypter(secretKey);
                fileEncrypterDecrypter.encrypt(jsonContent, this.getAccountCacheFile().getAbsolutePath());
            }
            catch (Exception e) {
                this.log.debug("Error writing encrypted account cache content.", e);
                this.getAccountCacheKeyFile().delete();
                this.writeAccountCacheToFile(accountCache, file);
            }
        }
    }

    public AccountCache getAccountCache() {
        File file = this.getAccountCacheFile();
        File keyFile = this.getAccountCacheKeyFile();
        if (!file.exists()) {
            return new AccountCache();
        }
        if (keyFile.exists()) {
            SecretKey secretKey = this.getSecretKeyFromFile();
            if (secretKey == null) {
                return new AccountCache();
            }
            try {
                FileEncrypterDecrypter fileEncrypterDecrypter = new FileEncrypterDecrypter(secretKey);
                String encContent = fileEncrypterDecrypter.decrypt(file);
                return this.readAccountCacheFromJson(encContent);
            }
            catch (Exception e) {
                this.log.warn("Account cache could not be read", e);
                return new AccountCache();
            }
        }
        AccountCache accountCache = this.readAccountCacheFromFile(file);
        return accountCache;
    }

    private AccountCache readAccountCacheFromJson(String content) {
        AccountCache accountCache;
        block2: {
            accountCache = null;
            try {
                accountCache = (AccountCache)this.objectMapper.readValue(content, AccountCache.class);
            }
            catch (Exception e) {
                accountCache = new AccountCache();
                this.log.warn("Could not read from account cache: " + e.getMessage());
                if (!this.log.isDebugEnabled()) break block2;
                this.log.error("Could not read from account cache", e);
            }
        }
        return accountCache;
    }

    private AccountCache readAccountCacheFromFile(File file) {
        AccountCache accountCache;
        block2: {
            accountCache = null;
            try {
                accountCache = (AccountCache)this.objectMapper.readValue(file, AccountCache.class);
            }
            catch (Exception e) {
                accountCache = new AccountCache();
                this.log.warn("Could not read from account cache: " + e.getMessage());
                if (!this.log.isDebugEnabled()) break block2;
                this.log.error("Could not read from account cache", e);
            }
        }
        return accountCache;
    }

    private String writeAccountCacheToJson(AccountCache accountCache) {
        try {
            StringWriter writer = new StringWriter();
            this.objectMapper.writeValue((Writer)writer, (Object)accountCache);
            return writer.toString();
        }
        catch (Exception e) {
            this.log.warn("Could not convert account cache to json", e);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Could not convert account cache to json", e);
            }
            return null;
        }
    }

    private void writeAccountCacheToFile(AccountCache accountCache, File file) {
        block2: {
            try {
                this.objectMapper.writeValue(file, (Object)accountCache);
            }
            catch (Exception e) {
                this.log.warn("Could not write to account cache", e);
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("Could not write to account cache", e);
            }
        }
    }

    public void clearAccountCache() {
        File file = this.getAccountCacheFile();
        file.delete();
        File keyFile = this.getAccountCacheKeyFile();
        keyFile.delete();
    }

    private SecretKey getSecretKeyFromFile() {
        try {
            File keyFile = this.getAccountCacheKeyFile();
            if (!keyFile.exists()) {
                return null;
            }
            Properties props = this.readKeyProperties(keyFile);
            String secretKey = (String)props.get(SECRET_KEY);
            if (!StringUtils.isEmpty(secretKey)) {
                return FileEncrypterDecrypter.getSecretKeyFromEncodedKey(secretKey);
            }
            return null;
        }
        catch (Exception e) {
            this.log.warn("Invalid secret key.");
            this.log.debug("Invalid key content", e);
            return null;
        }
    }

    private SecretKey generateNewSecretAndStore() {
        String key = null;
        try {
            key = FileEncrypterDecrypter.generateKey();
        }
        catch (Exception e) {
            this.log.debug("Error generating secret key. Something is really wrong.", e);
            this.log.warn("Secret generation failed. Keys will be stored in plain text");
            return null;
        }
        if (key == null) {
            return null;
        }
        Properties props = new Properties();
        props.put(SECRET_KEY, key);
        props.put(PROTECTION_MODE, "none");
        File keyFile = this.getAccountCacheKeyFile();
        this.writeKeyProperties(keyFile, props);
        return FileEncrypterDecrypter.getSecretKeyFromEncodedKey(key);
    }

    private File getAccountCacheFile() {
        return new File(this.targetFolder, ACCOUNT_CACHE);
    }

    private File getAccountCacheKeyFile() {
        return new File(this.targetFolder, ACCOUNT_CACHE + ".key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKeyProperties(File file, Properties props) {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            props.store(output, null);
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readKeyProperties(File file) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception io) {
            io.printStackTrace();
            Properties properties = new Properties();
            return properties;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

