/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.InvalidKeySpecException;
import org.aion4j.avm.helper.crypto.Account;
import org.aion4j.avm.helper.crypto.AccountKey;
import org.aion4j.avm.helper.crypto.KeyHelper;
import org.aion4j.avm.helper.util.HexUtil;

public class AccountGenerator {
    public static Account newAddress() {
        AccountKey accountKey = KeyHelper.generatePrivateKey();
        try {
            byte[] addressByte = KeyHelper.deriveAddress(accountKey.getPrivateKeyBytes());
            String privateKey = KeyHelper.generateWalletPrivateKey(accountKey);
            Account account = new Account();
            account.setPrivateKey(privateKey);
            account.setAddress(HexUtil.bytesToHexString(addressByte));
            return account;
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws InvalidAlgorithmParameterException, InvalidKeySpecException {
        new AccountGenerator();
        Account account = AccountGenerator.newAddress();
        System.out.println(account.getPrivateKey());
        System.out.printf(account.getAddress(), new Object[0]);
    }
}

