/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.crypto;

import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import org.aion4j.avm.helper.crypto.AccountKey;
import org.aion4j.avm.helper.signing.Blake2b;

public class KeyHelper {
    private static final String skEncodedPrefix = "302e020100300506032b657004220420";
    private static final String pkEncodedPrefix = "302a300506032b6570032100";
    private static final EdDSAParameterSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");

    public static AccountKey generatePrivateKey() {
        KeyPairGenerator keyPairGenerator = new KeyPairGenerator();
        KeyPair pair = keyPairGenerator.generateKeyPair();
        EdDSAPrivateKey privateKey = (EdDSAPrivateKey)pair.getPrivate();
        AccountKey accountKey = new AccountKey();
        accountKey.setPrivateKeyBytes(Utils.hexToBytes((String)Utils.bytesToHex((byte[])privateKey.getEncoded()).substring(32, 96)));
        accountKey.setPublicKeyBytes(privateKey.getAbyte());
        return accountKey;
    }

    public static byte[] deriveAddress(byte[] privateKeyBytes) throws InvalidKeySpecException {
        if (privateKeyBytes == null) {
            throw new NullPointerException("private key cannot be null");
        }
        if (privateKeyBytes.length != 32) {
            throw new IllegalArgumentException("private key mute be 32 bytes");
        }
        EdDSAPrivateKey privateKey = new EdDSAPrivateKey(new PKCS8EncodedKeySpec(KeyHelper.addSkPrefix(Utils.bytesToHex((byte[])privateKeyBytes))));
        byte[] publicKeyBytes = privateKey.getAbyte();
        return KeyHelper.computeA0Address(publicKeyBytes);
    }

    public static String generateWalletPrivateKey(AccountKey accountKey) {
        if (accountKey.getPrivateKeyBytes() == null) {
            throw new NullPointerException("private key cannot be null");
        }
        if (accountKey.getPublicKeyBytes() == null) {
            throw new NullPointerException("public key cannot be null");
        }
        String walletPrivateKey = Utils.bytesToHex((byte[])accountKey.getPrivateKeyBytes()) + Utils.bytesToHex((byte[])accountKey.getPublicKeyBytes());
        return walletPrivateKey;
    }

    private static byte[] addPkPrefix(String pkString) {
        String pkEncoded = pkEncodedPrefix + pkString;
        return Utils.hexToBytes((String)pkEncoded);
    }

    private static byte[] addSkPrefix(String skString) {
        String skEncoded = skEncodedPrefix + skString;
        return Utils.hexToBytes((String)skEncoded);
    }

    public static byte[] computeA0Address(byte[] publicKey) {
        byte A0_IDENTIFIER = -96;
        ByteBuffer buf = ByteBuffer.allocate(32);
        buf.put(A0_IDENTIFIER);
        buf.put(KeyHelper.blake256(publicKey), 1, 31);
        return buf.array();
    }

    private static byte[] blake256(byte[] input) {
        Blake2b.Digest digest = Blake2b.Digest.newInstance(32);
        digest.update(input);
        return digest.digest();
    }
}

