/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.faucet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.nettgryppa.security.HashCash;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.api.logs.ErrorDelegateLog;
import org.aion4j.avm.helper.api.logs.Slf4jLog;
import org.aion4j.avm.helper.exception.AVMRuntimeException;
import org.aion4j.avm.helper.exception.RemoteAvmCallException;
import org.aion4j.avm.helper.faucet.NetworkHelper;
import org.aion4j.avm.helper.faucet.model.Challenge;
import org.aion4j.avm.helper.faucet.model.Network;
import org.aion4j.avm.helper.faucet.model.TopupResult;
import org.aion4j.avm.helper.remote.RemoteAvmAdapter;
import org.aion4j.avm.helper.util.CryptoUtil;
import org.aion4j.avm.helper.util.StringUtils;
import org.slf4j.LoggerFactory;

public class FaucetService {
    private final ClassLoader avmJarClassLoader;
    private String nodeUrl;
    private String faucetWebUrl;
    private String faucetContractAddress;
    private String networkId;
    private Log log;
    private RemoteAvmAdapter remoteAvmAdapter;
    private long defaultGas;
    private long defaultGasPrice;

    public FaucetService(ClassLoader avmJarClassLoader, String nodeUrl, String faucetWebUrl, String faucetContractAddress, Log _log) {
        this.avmJarClassLoader = avmJarClassLoader;
        this.nodeUrl = nodeUrl;
        this.faucetWebUrl = faucetWebUrl;
        this.log = _log;
        Network network = this.resolveNetwork(nodeUrl, faucetContractAddress);
        this.faucetContractAddress = network != null ? network.getFaucetContract() : null;
        String string = this.networkId = network != null ? network.getId() : null;
        if (this.log == null) {
            this.log = new Slf4jLog(LoggerFactory.getLogger(FaucetService.class));
        }
        this.log.info("Network                 : " + network.getNetwork());
        this.log.info("Faucet contract address : " + network.getFaucetContract());
        this.log.info("");
        if (StringUtils.isEmpty(this.faucetContractAddress)) {
            throw new AVMRuntimeException(String.format("Faucet contract address is not set for network : %s ", network.getNetwork()));
        }
        Log remoteAdapterLog = _log != null && !_log.isDebugEnabled() ? new ErrorDelegateLog(this.log) : this.log;
        this.remoteAvmAdapter = new RemoteAvmAdapter(nodeUrl, remoteAdapterLog);
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){
            ObjectMapper mapper = new ObjectMapper();

            public String writeValue(Object value) {
                try {
                    return this.mapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)this.mapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    private Network resolveNetwork(String nodeUrl, String faucetContractAddress) {
        if (!StringUtils.isEmpty(faucetContractAddress)) {
            return new Network(null, null, null, faucetContractAddress);
        }
        NetworkHelper networkHelper = new NetworkHelper(this.log);
        Network network = networkHelper.getNetworkFromWeb3RpcUrl(nodeUrl);
        return network;
    }

    public void setDefaultGas(long defaultGas) {
        this.defaultGas = defaultGas;
    }

    public void setDefaultGasPrice(long defaultGasPrice) {
        this.defaultGasPrice = defaultGasPrice;
    }

    public void topup(String account, String accountPk) throws RemoteAvmCallException {
        boolean isFaucetWebCall = this.isFacetWebCallRequired(this.remoteAvmAdapter, account);
        if (isFaucetWebCall) {
            this.log.info("Let's register the address and get some minimum AION coins through Faucet Web");
            this.allocateInitialBalanceThroughFaucetWeb(account);
        }
        this.log.info("Let's get some coin from the Faucet contract");
        try {
            this.invokeContractForBalanceTopup(accountPk, account);
        }
        catch (Exception e) {
            this.log.debug("Account topup failed", e);
            throw new RemoteAvmCallException("Account topup failed", e);
        }
        BigInteger balance = this.remoteAvmAdapter.getBalance(account);
        if (balance == null || BigInteger.ZERO.equals(balance)) {
            this.log.error("Could not send some initial AION coins to the address");
            throw new RemoteAvmCallException("Topup registration failed for address : " + account);
        }
        BigDecimal aionBalance = CryptoUtil.ampToAion(balance);
        this.log.info("Account           : " + account);
        this.log.info(String.format("New balance (nAmp): %s (%s Aion)", balance, String.format("%.12f", aionBalance)));
    }

    private void allocateInitialBalanceThroughFaucetWeb(String account) throws RemoteAvmCallException {
        Challenge challenge = null;
        try {
            this.log.info("Fetching challenge from the Faucet web server ....");
            challenge = this.getChallenge();
        }
        catch (UnirestException ex) {
            this.log.error(String.format("Get challenge failed", new Object[0]), ex);
            throw new RemoteAvmCallException("Get challenge failed", (Exception)((Object)ex));
        }
        if (challenge == null) {
            throw new RemoteAvmCallException("Get challenge failed");
        }
        HashMap<String, List<String>> extensions = new HashMap<String, List<String>>();
        ArrayList<String> extensionList = new ArrayList<String>();
        extensionList.add(String.valueOf(challenge.getCounter()));
        extensionList.add(account);
        if (!StringUtils.isEmpty(this.networkId)) {
            extensionList.add(this.networkId);
        }
        extensions.put("data", extensionList);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Extensions >>>>>>> " + extensionList);
        }
        this.log.info("Start genereting proof with value " + challenge.getValue());
        if (challenge.getValue() > 30) {
            this.log.info("You may be making too many requests to the faucet. Your challenge is too high. It might take little longer to generate the proof.");
        }
        long t1 = System.currentTimeMillis();
        HashCash cash = null;
        try {
            cash = HashCash.mintCash(challenge.getMessage(), extensions, challenge.getValue(), 1);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Error generating proof", e);
            throw new RemoteAvmCallException("Error generating proof");
        }
        if (cash == null) {
            throw new RemoteAvmCallException("Error generating proof");
        }
        long t2 = System.currentTimeMillis();
        this.log.info("Time spent in minting proof : " + (t2 - t1) / 1000L + "sec");
        this.log.info("Send hascash proof to server : " + cash.toString());
        TopupResult topupResult = null;
        try {
            topupResult = this.submitHashCash(account, cash);
            if (topupResult == null) {
                this.log.error("Account could not be credited");
                throw new RemoteAvmCallException("Error in crediting account");
            }
            this.log.info("Register result >> " + topupResult);
        }
        catch (UnirestException e) {
            this.log.error("Topup failed for address : " + account, e);
            throw new RemoteAvmCallException("Topup failed for address : " + account);
        }
        if (topupResult != null && StringUtils.isEmpty(topupResult.getTxHash())) {
            throw new RemoteAvmCallException("Topup transaction failed. Something is wrong.");
        }
        this.remoteAvmAdapter.startGetReceipt(topupResult.getTxHash(), "tail", "silent", null, this.log);
    }

    private void invokeContractForBalanceTopup(String pk, String account) throws RemoteAvmCallException {
        Class localAvmClazz = this.getLocalAVMClass();
        Method encodeMethodCallMethod = null;
        try {
            encodeMethodCallMethod = localAvmClazz.getMethod("encodeMethodCall", String.class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RemoteAvmCallException(e.getMessage(), e);
        }
        String encodedMethodCall = null;
        try {
            encodedMethodCall = (String)encodeMethodCallMethod.invoke(null, "topUp", new Object[0]);
        }
        catch (Exception e) {
            throw new RemoteAvmCallException(e.getMessage(), e);
        }
        this.log.info("Encoded method call data: " + encodedMethodCall);
        Object remoteAVMNode = null;
        String retData = null;
        retData = this.remoteAvmAdapter.getRemoteAvmNode().sendRawTransaction(this.faucetContractAddress, pk, encodedMethodCall, BigInteger.ZERO, this.defaultGas, this.defaultGasPrice);
        if (retData != null) {
            this.remoteAvmAdapter.startGetReceipt(retData, "tail", "silent", null, this.log);
        }
    }

    private boolean isFacetWebCallRequired(RemoteAvmAdapter remoteAvmAdapter, String address) {
        BigInteger balance = remoteAvmAdapter.getBalance(address);
        this.log.info("Fetched existing balance for the account : " + balance);
        if (balance == null || BigInteger.ZERO.equals(balance)) {
            this.log.debug("Address balance is null. Let's try to get some minimum balance for the account through Faucet Web.");
            return true;
        }
        return false;
    }

    private TopupResult submitHashCash(String account, HashCash hashCash) throws UnirestException {
        HttpResponse httpResponse = Unirest.post((String)(this.faucetWebUrl + "/register")).header("Content-Type", "text/plain").body(hashCash.toString()).asObject(TopupResult.class);
        if (httpResponse.getStatus() != 200) {
            return null;
        }
        return (TopupResult)httpResponse.getBody();
    }

    private Challenge getChallenge() throws UnirestException {
        return (Challenge)Unirest.get((String)(this.faucetWebUrl + "/challenge")).header("accept", "application/json").header("Content-Type", "application/json").asObject(Challenge.class).getBody();
    }

    private Class getLocalAVMClass() {
        try {
            return this.avmJarClassLoader.loadClass("org.aion4j.avm.helper.local.LocalAvmNode");
        }
        catch (ClassNotFoundException e) {
            throw new AVMRuntimeException("LocalAvmNode class not found", e);
        }
    }
}

