/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.faucet;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.faucet.model.Network;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.avm.helper.util.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class NetworkHelper {
    private static final String NETWORK_DETAILS_URL = "https://bloxbean.github.io/aion4j-release/networks.json";
    private Log log;

    public NetworkHelper(Log log) {
        this.log = log;
    }

    public Network getNetworkFromWeb3RpcUrl(String nodeUrl) {
        if (StringUtils.isEmpty(nodeUrl)) {
            return null;
        }
        if (StringUtils.isEmpty(nodeUrl)) {
            return null;
        }
        RemoteAVMNode remoteAVMNode = new RemoteAVMNode(nodeUrl, this.log);
        String genesisHash = remoteAVMNode.getGenesisBlockHash();
        if (StringUtils.isEmpty(genesisHash)) {
            return null;
        }
        List<Network> networks = this.getNetworks();
        if (networks == null) {
            return null;
        }
        for (Network network : networks) {
            if (!genesisHash.equals(network.getGenesisHash())) continue;
            return network;
        }
        return null;
    }

    public List<Network> getNetworks() {
        JsonNode networksJson = this.readContentFromNetwork();
        try {
            if (networksJson != null) {
                return this.parseNetworks(networksJson);
            }
        }
        catch (Exception e) {
            this.log.debug("Error fetching network details : https://bloxbean.github.io/aion4j-release/networks.json", e);
        }
        try {
            networksJson = this.readFromLocalResource();
            if (networksJson != null) {
                return this.parseNetworks(networksJson);
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to get network details", ex);
        }
        return Collections.EMPTY_LIST;
    }

    private List<Network> parseNetworks(JsonNode jsonNode) {
        JSONArray networksJson = jsonNode.getObject().getJSONArray("networks");
        ArrayList<Network> networks = new ArrayList<Network>();
        for (int i = 0; i < networksJson.length(); ++i) {
            JSONObject networkNode = networksJson.getJSONObject(i);
            String id = networkNode.getString("id");
            String genesisHash = networkNode.getString("genesisHash");
            String networkDesc = networkNode.getString("network");
            String faucetContract = networkNode.getString("faucetContract");
            Network network = new Network(id, genesisHash, networkDesc, faucetContract);
            networks.add(network);
        }
        return networks;
    }

    private JsonNode readContentFromNetwork() {
        try {
            Unirest.setTimeouts((long)2000L, (long)4000L);
            HttpResponse response = Unirest.get((String)NETWORK_DETAILS_URL).header("accept", "application/json").asJson();
            if (response.getStatus() != 200) {
                this.log.debug("Unable to fetch network details from : https://bloxbean.github.io/aion4j-release/networks.json  httpstatus: " + response.getStatus());
                return null;
            }
            if (response != null) {
                return (JsonNode)response.getBody();
            }
            return null;
        }
        catch (Exception e) {
            this.log.debug("Unable to fetch network details from : https://bloxbean.github.io/aion4j-release/networks.json", e);
            this.log.warn("Unable to fetch network details from : https://bloxbean.github.io/aion4j-release/networks.json");
            this.log.info("Let's try to get network details from local cache");
            return null;
        }
    }

    private JsonNode readFromLocalResource() {
        InputStream inputStream = this.getClass().getResourceAsStream("/networks.json");
        String content = null;
        try {
            content = this.readFromInputStream(inputStream);
            JsonNode jsonNode = new JsonNode(content);
            return jsonNode;
        }
        catch (IOException e) {
            this.log.error("Error reading network details from local cache", e);
            return null;
        }
    }

    private String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        return resultStringBuilder.toString();
    }
}

