/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.local;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import org.aion.avm.embed.crypto.CryptoUtil;
import org.aion.avm.embed.crypto.Ed25519Signature;
import org.aion.avm.embed.crypto.ISignature;
import org.aion.rlp.RLP;
import org.aion.rlp.RLPElement;
import org.aion.rlp.RLPList;
import org.aion.types.AionAddress;
import org.aion.types.InternalTransaction;
import org.aion4j.avm.helper.crypto.KeyHelper;
import org.aion4j.avm.helper.signing.Blake2b;
import org.aion4j.avm.helper.signing.SignedTransactionBuilder;

public class InvokableTxUtil {
    private static final byte VERSION = 0;
    private static AionAddress ZERO_ADDRESS = new AionAddress(new byte[32]);
    private static final int RLP_META_TX_NONCE = 0;
    private static final int RLP_META_TX_TO = 1;
    private static final int RLP_META_TX_VALUE = 2;
    private static final int RLP_META_TX_DATA = 3;
    private static final int RLP_META_TX_EXECUTOR = 4;
    private static final int RLP_META_TX_SIG = 5;

    public static byte[] encodeInvokableTransaction(String privateKey, BigInteger nonce, AionAddress destination, BigInteger value, byte[] data, AionAddress executor) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (privateKey == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (nonce == null) {
            throw new NullPointerException("Nonce cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        EdDSAPrivateKey key = SignedTransactionBuilder.getEDSAPrivateKey(privateKey);
        byte[] rlpEncodingWithoutSignature = InvokableTxUtil.rlpEncodeWithoutSignature(nonce, destination, value, data, executor);
        byte[] signBytes = SignedTransactionBuilder.sign(key, InvokableTxUtil.blake2b(InvokableTxUtil.prependVersion(rlpEncodingWithoutSignature)));
        Ed25519Signature signature = Ed25519Signature.fromPublicKeyAndSignature((byte[])key.getAbyte(), (byte[])signBytes);
        byte[] encoding = InvokableTxUtil.rlpEncode(nonce, destination, value, data, executor, (ISignature)signature);
        return InvokableTxUtil.prependVersion(encoding);
    }

    public static InternalTransaction decode(byte[] encodingWithVersion, AionAddress callingAddress, long energyPrice, long energyLimit) {
        Ed25519Signature is;
        AionAddress executor;
        AionAddress destination;
        RLPList decodedTxList;
        if (encodingWithVersion[0] != 0) {
            return null;
        }
        byte[] rlpEncoding = Arrays.copyOfRange(encodingWithVersion, 1, encodingWithVersion.length);
        try {
            decodedTxList = RLP.decode2(rlpEncoding);
        }
        catch (Exception e) {
            return null;
        }
        RLPList tx = (RLPList)decodedTxList.get(0);
        BigInteger nonce = new BigInteger(1, ((RLPElement)tx.get(0)).getRLPData());
        BigInteger value = new BigInteger(1, ((RLPElement)tx.get(2)).getRLPData());
        byte[] data = ((RLPElement)tx.get(3)).getRLPData();
        try {
            destination = new AionAddress(((RLPElement)tx.get(1)).getRLPData());
        }
        catch (Exception e) {
            destination = null;
        }
        try {
            executor = new AionAddress(((RLPElement)tx.get(4)).getRLPData());
        }
        catch (Exception e) {
            executor = null;
        }
        if (executor != null && !executor.equals((Object)ZERO_ADDRESS) && !executor.equals((Object)callingAddress)) {
            System.err.println("Invokable tx -> executor address is not matching calling address.");
            System.err.println("Invokable tx -> executor address: " + executor.toString());
            System.err.println("Invokable tx -> calling address: " + callingAddress != null ? callingAddress.toString() : null);
            return null;
        }
        byte[] sigs = ((RLPElement)tx.get(5)).getRLPData();
        if (sigs != null) {
            is = Ed25519Signature.fromCombinedPublicKeyAndSignature((byte[])sigs);
            if (is == null) {
                return null;
            }
        } else {
            return null;
        }
        Ed25519Signature signature = is;
        byte[] address = KeyHelper.computeA0Address(is.getPublicKey(new byte[0]));
        AionAddress sender = new AionAddress(address);
        try {
            return InvokableTxUtil.createFromRlp(nonce, sender, destination, value, data, executor, energyLimit, energyPrice, (ISignature)signature, encodingWithVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Invokable tx -> unable to decode rlpEncoding. " + e);
            return null;
        }
    }

    private static byte[] rlpEncodeWithoutSignature(BigInteger nonce, AionAddress destination, BigInteger value, byte[] data, AionAddress executor) {
        byte[] nonceEncoded = RLP.encodeBigInteger(nonce);
        byte[] destinationEncoded = RLP.encodeElement(destination == null ? null : destination.toByteArray());
        byte[] valueEncoded = RLP.encodeBigInteger(value);
        byte[] dataEncoded = RLP.encodeElement(data);
        byte[] executorEncoded = RLP.encodeElement(executor == null ? null : executor.toByteArray());
        return RLP.encodeList(nonceEncoded, destinationEncoded, valueEncoded, dataEncoded, executorEncoded);
    }

    private static byte[] rlpEncode(BigInteger nonce, AionAddress destination, BigInteger value, byte[] data, AionAddress executor, ISignature signature) {
        byte[] nonceEncoded = RLP.encodeBigInteger(nonce);
        byte[] destinationEncoded = RLP.encodeElement(destination == null ? null : destination.toByteArray());
        byte[] valueEncoded = RLP.encodeBigInteger(value);
        byte[] dataEncoded = RLP.encodeElement(data);
        byte[] executorEncoded = RLP.encodeElement(executor == null ? null : executor.toByteArray());
        byte[] signatureEncoded = RLP.encodeElement(InvokableTxUtil.combinePublicKeyAndSignature(signature));
        return RLP.encodeList(nonceEncoded, destinationEncoded, valueEncoded, dataEncoded, executorEncoded, signatureEncoded);
    }

    private static byte[] combinePublicKeyAndSignature(ISignature signature) {
        int publicKeyLength = signature.getPublicKey(null).length;
        int sigLength = signature.getSignature().length;
        byte[] buf = new byte[publicKeyLength + sigLength];
        System.arraycopy(signature.getPublicKey(null), 0, buf, 0, publicKeyLength);
        System.arraycopy(signature.getSignature(), 0, buf, publicKeyLength, sigLength);
        return buf;
    }

    private static InternalTransaction createFromRlp(BigInteger nonce, AionAddress sender, AionAddress destination, BigInteger value, byte[] data, AionAddress executor, long energyLimit, long energyPrice, ISignature signature, byte[] rlpEncodingWithVersion) {
        byte[] transactionHashWithoutSignature = InvokableTxUtil.blake2b(InvokableTxUtil.prependVersion(InvokableTxUtil.rlpEncodeWithoutSignature(nonce, destination, value, data, executor)));
        if (!CryptoUtil.verifyEdDSA((byte[])transactionHashWithoutSignature, (byte[])signature.getSignature(), (byte[])signature.getPublicKey(null))) {
            throw new IllegalStateException("Signature does not match Transaction Content");
        }
        byte[] transactionHash = InvokableTxUtil.blake2b(rlpEncodingWithVersion);
        if (destination == null) {
            return InternalTransaction.contractCreateInvokableTransaction((InternalTransaction.RejectedStatus)InternalTransaction.RejectedStatus.NOT_REJECTED, (AionAddress)sender, (BigInteger)nonce, (BigInteger)value, (byte[])data, (long)energyLimit, (long)energyPrice, (byte[])transactionHash);
        }
        return InternalTransaction.contractCallInvokableTransaction((InternalTransaction.RejectedStatus)InternalTransaction.RejectedStatus.NOT_REJECTED, (AionAddress)sender, (AionAddress)destination, (BigInteger)nonce, (BigInteger)value, (byte[])data, (long)energyLimit, (long)energyPrice, (byte[])transactionHash);
    }

    private static byte[] prependVersion(byte[] encoding) {
        byte[] ret = new byte[encoding.length + 1];
        ret[0] = 0;
        System.arraycopy(encoding, 0, ret, 1, encoding.length);
        return ret;
    }

    private static byte[] blake2b(byte[] msg) {
        Blake2b.Digest digest = Blake2b.Digest.newInstance(32);
        digest.update(msg);
        return digest.digest();
    }
}

