/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.local;

import avm.Address;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.aion.avm.core.AvmConfiguration;
import org.aion.avm.core.AvmImpl;
import org.aion.avm.core.AvmTransactionUtil;
import org.aion.avm.core.CommonAvmFactory;
import org.aion.avm.core.ExecutionType;
import org.aion.avm.core.IExternalCapabilities;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.util.Helpers;
import org.aion.avm.tooling.ABIUtil;
import org.aion.avm.tooling.abi.ABICompiler;
import org.aion.avm.tooling.deploy.OptimizedJarBuilder;
import org.aion.avm.userlib.CodeAndArguments;
import org.aion.kernel.TestingBlock;
import org.aion.kernel.TestingState;
import org.aion.types.AionAddress;
import org.aion.types.Log;
import org.aion.types.Transaction;
import org.aion.types.TransactionResult;
import org.aion4j.avm.helper.api.CallResponse;
import org.aion4j.avm.helper.api.DeployResponse;
import org.aion4j.avm.helper.exception.CallFailedException;
import org.aion4j.avm.helper.exception.DeploymentFailedException;
import org.aion4j.avm.helper.exception.LocalAVMException;
import org.aion4j.avm.helper.local.TestStandardCapabilities;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.avm.helper.util.HexUtil;
import org.aion4j.avm.helper.util.MethodCallArgsUtil;

public class LocalAvmNode {
    private static final BigInteger ONE_AION = new BigInteger("1000000000000000000");
    public static final int ABI_COMPILER_VERSION = 1;
    private AionAddress defaultAddress;
    TestingBlock block = new TestingBlock(new byte[32], 1L, Helpers.randomAddress(), System.currentTimeMillis(), new byte[0]);
    private AvmImpl avm;
    private TestingState kernel;
    private long energyLimit = 100000000L;
    private long energyPrice = 1L;
    private boolean forceAbiCompile = false;
    private boolean preserveDebuggability = false;

    public LocalAvmNode(String storagePath, String senderAddress) {
        if (storagePath.isEmpty()) {
            throw new LocalAVMException("Storage path cannot be null for embedded Avm deployment");
        }
        this.defaultAddress = new AionAddress(Helpers.hexStringToBytes((String)senderAddress));
        this.init(storagePath);
    }

    public void init(String storagePath) {
        LocalAvmNode.verifyStorageExists(storagePath);
        File storagePathFile = new File(storagePath);
        this.kernel = new TestingState(storagePathFile, this.block);
        if (this.kernel.getBalance(this.defaultAddress) == null || this.kernel.getBalance(this.defaultAddress) == BigInteger.ZERO) {
            BigInteger initialBalance = ONE_AION.multiply(new BigInteger("100000"));
            this.kernel.createAccount(this.defaultAddress);
            this.kernel.adjustBalance(this.defaultAddress, initialBalance);
            System.out.println(String.format("Created default account %s with balance %s", this.defaultAddress, initialBalance));
        }
        AvmConfiguration avmConfiguration = new AvmConfiguration();
        avmConfiguration.enableVerboseConcurrentExecutor = ConfigUtil.getAvmConfigurationBooleanProps("enableVerboseConcurrentExecutor", false);
        avmConfiguration.enableVerboseContractErrors = ConfigUtil.getAvmConfigurationBooleanProps("enableVerboseContractErrors", false);
        this.preserveDebuggability = avmConfiguration.preserveDebuggability = ConfigUtil.getAvmConfigurationBooleanProps("preserveDebuggability", false);
        this.avm = CommonAvmFactory.buildAvmInstanceForConfiguration((IExternalCapabilities)new TestStandardCapabilities(), (AvmConfiguration)avmConfiguration);
    }

    public DeployResponse deploy(String jarFilePath) throws DeploymentFailedException {
        return this.deploy(jarFilePath, null, null, BigInteger.ZERO);
    }

    public DeployResponse deploy(String jarFilePath, String deployArgs, String deployer) throws DeploymentFailedException {
        return this.deploy(jarFilePath, deployArgs, deployer, BigInteger.ZERO);
    }

    public DeployResponse deploy(String jarFilePath, String deployArgs, String deployer, BigInteger value) throws DeploymentFailedException {
        AionAddress deployerAddress = null;
        deployerAddress = deployer == null || deployer.isEmpty() ? this.defaultAddress : new AionAddress(Helpers.hexStringToBytes((String)deployer));
        byte[] deployArgsBytes = null;
        if (deployArgs != null && !deployArgs.isEmpty()) {
            try {
                deployArgsBytes = LocalAvmNode.encodeDeployArgsString(deployArgs);
            }
            catch (CallFailedException e) {
                throw new DeploymentFailedException("Deployment error", e);
            }
        }
        if (value == null) {
            value = BigInteger.ZERO;
        }
        Transaction txContext = this.createDeployTransaction(jarFilePath, deployArgsBytes, deployerAddress, value);
        DeployResponse deployResponse = this.createDApp(txContext);
        return deployResponse;
    }

    public CallResponse call(String contract, String sender, String method, String argsString, BigInteger value) throws CallFailedException {
        AionAddress contractAddress = new AionAddress(Helpers.hexStringToBytes((String)contract));
        AionAddress senderAddress = null;
        senderAddress = sender == null || sender.isEmpty() ? this.defaultAddress : new AionAddress(Helpers.hexStringToBytes((String)sender));
        Object[] args = null;
        try {
            args = MethodCallArgsUtil.parseMethodArgs(argsString);
        }
        catch (Exception e) {
            throw new CallFailedException("Method argument parsing error", e);
        }
        Transaction txContext = this.createCallTransaction(contractAddress, senderAddress, method, args, value, this.energyLimit, this.energyPrice);
        this.kernel.generateBlock();
        TransactionResult result = this.avm.run((IExternalState)this.kernel, new Transaction[]{txContext}, ExecutionType.ASSUME_MAINCHAIN, this.kernel.getBlockNumber() - 1L)[0].getResult();
        if (result.transactionStatus.isSuccess()) {
            CallResponse response;
            block15: {
                response = new CallResponse();
                byte[] retData = result.copyOfTransactionOutput().orElse(new byte[0]);
                if (retData != null) {
                    try {
                        Object retObj = ABIUtil.decodeOneObject((byte[])retData);
                        if (retObj != null && retObj instanceof Address) {
                            String addStr = HexUtil.bytesToHexString(((Address)retObj).toByteArray());
                            response.setData(addStr);
                            break block15;
                        }
                        if (retObj != null && LocalAvmNode.is2DArray(retObj)) {
                            String finalRet = MethodCallArgsUtil.print2DArray(retObj);
                            if (finalRet == null) {
                                response.setData(HexUtil.bytesToHexString(retData));
                            } else {
                                response.setData(finalRet);
                            }
                            break block15;
                        }
                        if (retObj != null && LocalAvmNode.isArray(retObj)) {
                            String finalRet = MethodCallArgsUtil.printArray(retObj);
                            if (finalRet == null) {
                                response.setData(HexUtil.bytesToHexString(retData));
                            } else {
                                response.setData(finalRet);
                            }
                            break block15;
                        }
                        response.setData(retObj);
                    }
                    catch (Exception e) {
                        response.setData(HexUtil.bytesToHexString(retData));
                    }
                } else {
                    response.setData(null);
                }
            }
            response.setEnergyUsed(result.energyUsed);
            response.setSuccess(true);
            response.setStatusMessage(result.transactionStatus.toString());
            this.printExecutionLog(result.logs);
            return response;
        }
        byte[] retData = result.copyOfTransactionOutput().orElse(new byte[0]);
        if (retData != null) {
            String resultData = Helpers.bytesToHexString((byte[])retData);
            throw new CallFailedException(String.format("Contract call failed. Cause: %s, Output: %s", result.transactionStatus.causeOfError, resultData));
        }
        throw new CallFailedException(String.format("Contract call failed. Cause: %s, Output: %s", result.transactionStatus.causeOfError, retData));
    }

    private void printExecutionLog(List<Log> executionLogs) {
        if (executionLogs != null && executionLogs.size() > 0) {
            System.out.println("************************ Execution Logs ****************************");
            executionLogs.forEach(exLog -> {
                List topics;
                System.out.println("Hex Data: " + HexUtil.bytesToHexString(exLog.copyOfData()));
                if (exLog.copyOfTopics() != null && (topics = exLog.copyOfTopics()) != null) {
                    for (byte[] topic : topics) {
                        System.out.println("Topic: " + HexUtil.bytesToHexString(topic));
                    }
                }
                System.out.println("  ");
            });
            System.out.println("************************ Execution Logs ****************************\n");
        }
    }

    private DeployResponse createDApp(Transaction txContext) throws DeploymentFailedException {
        this.kernel.generateBlock();
        TransactionResult result = this.avm.run((IExternalState)this.kernel, new Transaction[]{txContext}, ExecutionType.ASSUME_MAINCHAIN, this.kernel.getBlockNumber() - 1L)[0].getResult();
        if (result.transactionStatus.isSuccess()) {
            DeployResponse deployResponse = new DeployResponse();
            String dappAddress = Helpers.bytesToHexString((byte[])result.copyOfTransactionOutput().orElse(new byte[0]));
            deployResponse.setAddress(dappAddress);
            deployResponse.setEnergyUsed(result.energyUsed);
            deployResponse.setSuccess(true);
            deployResponse.setStatusMessage(result.transactionStatus.toString());
            return deployResponse;
        }
        String resultData = Helpers.bytesToHexString((byte[])result.copyOfTransactionOutput().orElse(new byte[0]));
        throw new DeploymentFailedException(String.format("Contract deployment failed. Cause: %s, Output: %s", result.transactionStatus.causeOfError, resultData));
    }

    private Transaction createDeployTransaction(String jarPath, byte[] deployArgs, AionAddress sender, BigInteger value) throws DeploymentFailedException {
        byte[] jar;
        Path path = Paths.get(jarPath, new String[0]);
        try {
            jar = Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new DeploymentFailedException("deploy : Invalid location of contract jar - " + jarPath);
        }
        byte[] deployBytes = new CodeAndArguments(jar, deployArgs).encodeToBytes();
        if (this.forceAbiCompile) {
            deployBytes = LocalAvmNode.compileDappBytes(deployBytes, this.preserveDebuggability);
        }
        Transaction createTransaction = AvmTransactionUtil.create((AionAddress)sender, (BigInteger)this.kernel.getNonce(sender), (BigInteger)value, (byte[])deployBytes, (long)this.energyLimit, (long)this.energyPrice);
        return createTransaction;
    }

    private static byte[] compileDappBytes(byte[] dappBytesWithArgs, boolean isDebugMode) {
        CodeAndArguments oldCodeAndArguments = CodeAndArguments.decodeFromBytes((byte[])dappBytesWithArgs);
        byte[] optimizedDappBytes = new OptimizedJarBuilder(isDebugMode, oldCodeAndArguments.code, 1).withUnreachableMethodRemover().withRenamer().withConstantRemover().getOptimizedBytes();
        CodeAndArguments newCodeAndArguments = new CodeAndArguments(optimizedDappBytes, oldCodeAndArguments.arguments);
        byte[] deployBytes = newCodeAndArguments.encodeToBytes();
        return deployBytes;
    }

    public Transaction createCallTransaction(AionAddress contract, AionAddress sender, String method, Object[] args, BigInteger value, long energyLimit, long energyPrice) {
        byte[] arguments = ABIUtil.encodeMethodArguments((String)method, (Object[])args);
        BigInteger biasedNonce = this.kernel.getNonce(sender);
        Transaction callTransaction = AvmTransactionUtil.call((AionAddress)sender, (AionAddress)contract, (BigInteger)biasedNonce, (BigInteger)value, (byte[])arguments, (long)energyLimit, (long)energyPrice);
        return callTransaction;
    }

    public boolean createAccountWithBalance(String address, BigInteger balance) {
        AionAddress account = new AionAddress(Helpers.hexStringToBytes((String)address));
        if (this.kernel.getBalance(account) == null || this.kernel.getBalance(account) == BigInteger.ZERO) {
            this.kernel.createAccount(account);
            this.kernel.adjustBalance(account, balance);
            System.out.println(String.format("Create account %s with balance %d", address, balance.longValue()));
            return true;
        }
        System.out.println("Account already exists");
        return false;
    }

    public boolean transfer(String toAddress, BigInteger amount) {
        AionAddress account = new AionAddress(Helpers.hexStringToBytes((String)toAddress));
        if (this.kernel.getBalance(account) == null) {
            this.kernel.createAccount(account);
        }
        this.kernel.adjustBalance(account, amount);
        return true;
    }

    public BigInteger getBalance(String address) {
        AionAddress account = new AionAddress(Helpers.hexStringToBytes((String)address));
        BigInteger balance = this.kernel.getBalance(account);
        if (balance == null) {
            return BigInteger.ZERO;
        }
        return balance;
    }

    public BigInteger getNonce(String address) {
        AionAddress account = new AionAddress(Helpers.hexStringToBytes((String)address));
        BigInteger nonce = this.kernel.getNonce(account);
        if (nonce == null) {
            return BigInteger.ZERO;
        }
        return nonce;
    }

    public void explore(String dappAddress, PrintStream printStream) throws Exception {
        throw new UnsupportedOperationException("Explorer command is no longer supported.");
    }

    public void setForceAbiCompile(boolean flag2) {
        this.forceAbiCompile = flag2;
    }

    public static byte[] encodeDeployArgsString(String deployArgs) throws CallFailedException {
        Object[] args = null;
        try {
            args = MethodCallArgsUtil.parseMethodArgs(deployArgs);
        }
        catch (Exception e) {
            throw new CallFailedException("Deploy arument parsing error", e);
        }
        if (args == null) {
            System.out.println("Not able to encode deploy args properly");
            return null;
        }
        return ABIUtil.encodeDeploymentArguments((Object[])args);
    }

    public static String getBytesForDeploy(String dappJarPath, String deployArgsStr) throws CallFailedException {
        try {
            Path path = Paths.get(dappJarPath, new String[0]);
            byte[] jar = Files.readAllBytes(path);
            byte[] deployArgsBytes = null;
            if (deployArgsStr != null && !deployArgsStr.isEmpty()) {
                deployArgsBytes = LocalAvmNode.encodeDeployArgsString(deployArgsStr);
            }
            if (deployArgsBytes == null) {
                deployArgsBytes = new byte[]{};
            }
            return Helpers.bytesToHexString((byte[])new CodeAndArguments(jar, deployArgsBytes).encodeToBytes());
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return null;
        }
    }

    public static String encodeMethodCallWithArgsString(String method, String methodArgs) throws CallFailedException {
        Object[] args = null;
        try {
            args = MethodCallArgsUtil.parseMethodArgs(methodArgs);
        }
        catch (Exception e) {
            throw new CallFailedException("Method argument parsing error", e);
        }
        return LocalAvmNode.encodeMethodCall(method, args);
    }

    public static String encodeMethodCall(String method, Object[] args) {
        return Helpers.bytesToHexString((byte[])ABIUtil.encodeMethodArguments((String)method, (Object[])args));
    }

    public static Object decodeResult(String hex) {
        try {
            Object result = ABIUtil.decodeOneObject((byte[])HexUtil.hexStringToBytes(hex));
            if (result != null) {
                if (result instanceof Address) {
                    return HexUtil.bytesToHexString(((Address)result).toByteArray());
                }
                if (result != null && LocalAvmNode.is2DArray(result)) {
                    String finalRet = MethodCallArgsUtil.print2DArray(result);
                    if (finalRet == null) {
                        return hex;
                    }
                    return finalRet;
                }
                if (result != null && LocalAvmNode.isArray(result)) {
                    String finalRet = MethodCallArgsUtil.printArray(result);
                    if (finalRet == null) {
                        return hex;
                    }
                    return finalRet;
                }
                return result.toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] compileJarBytes(byte[] jarBytes) {
        ABICompiler compiler = ABICompiler.compileJarBytes((byte[])jarBytes, (int)1);
        return compiler.getJarFileBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compileJarBytesAndWriteAbi(byte[] jarBytes, OutputStream output) {
        ABICompiler compiler = ABICompiler.compileJarBytes((byte[])jarBytes, (int)1);
        byte[] compiledBytes = compiler.getJarFileBytes();
        try {
            compiler.writeAbi(output, 1);
        }
        catch (Exception e) {
            System.out.println("Unable to write abi file to the filesystem. " + e.getMessage());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        return compiledBytes;
    }

    public static byte[] optimizeJarBytes(byte[] jarBytes, boolean debugMode) {
        byte[] optimizedJar = new OptimizedJarBuilder(debugMode, jarBytes, 1).withUnreachableMethodRemover().withRenamer().withConstantRemover().getOptimizedBytes();
        return optimizedJar;
    }

    private static void verifyStorageExists(String storageRoot) {
        boolean didCreate;
        File directory = new File(storageRoot);
        if (!directory.isDirectory() && !(didCreate = directory.mkdirs())) {
            throw new LocalAVMException("Unable create storage folder");
        }
    }

    public void shutdown() {
        this.avm.shutdown();
    }

    private static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    private static boolean is2DArray(Object obj) {
        return obj != null && obj.getClass().getTypeName().endsWith("[][]");
    }
}

