/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.remote;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.aion.base.util.ByteUtil;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.exception.AVMRuntimeException;
import org.aion4j.avm.helper.signing.SignedTransactionBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class RemoteAVMNode {
    private String web3RpcUrl;
    private Log log;

    public RemoteAVMNode(String web3RpcUrl, Log log) {
        this.web3RpcUrl = web3RpcUrl;
        this.log = log;
    }

    public boolean unlock(String address, String password) {
        try {
            JSONObject jo = this.getJsonHeader("personal_unlockAccount");
            ArrayList<String> params = new ArrayList<String>();
            params.add(address);
            params.add(password);
            params.add("600");
            jo.put("params", params);
            this.log.info("Web3Rpc request data:\n " + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return false;
            }
            return jsonNode.getObject().getBoolean("result");
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("Web3Rpc call failed to unlock account", (Exception)((Object)e));
        }
    }

    public String deploy(String address, String dappJarContent, long gas, long gasPrice) {
        try {
            JSONObject jo = this.getJsonHeader("eth_sendTransaction");
            ArrayList params = new ArrayList();
            JSONArray paramArray = new JSONArray();
            JSONObject txnJo = new JSONObject();
            txnJo.put("from", (Object)address);
            txnJo.put("gas", gas);
            txnJo.put("gasPrice", gasPrice);
            txnJo.put("type", (Object)"0x2");
            txnJo.put("data", (Object)dappJarContent);
            paramArray.put((Object)txnJo);
            jo.put("params", (Object)paramArray);
            this.log.debug("Request \n : " + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel:\n " + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.optString("result");
            }
            throw new AVMRuntimeException("Dapp deployment failed. Reason: " + error);
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("Dapp deployment failed", (Exception)((Object)e));
        }
    }

    public String call(String contract, String address, String callData, BigInteger value, long gas, long gasPrice) {
        try {
            this.log.info("Invoking method of the contract ...");
            JSONObject jo = this.getJsonHeader("eth_call");
            ArrayList params = new ArrayList();
            JSONArray paramArray = new JSONArray();
            JSONObject txnJo = new JSONObject();
            txnJo.put("from", (Object)address);
            txnJo.put("to", (Object)contract);
            txnJo.put("gas", gas);
            txnJo.put("gasPrice", gasPrice);
            txnJo.put("data", (Object)("0x" + callData));
            if (value != null) {
                txnJo.put("value", (Object)value);
            }
            paramArray.put((Object)txnJo);
            jo.put("params", (Object)paramArray);
            this.log.info("Web3Rpc request data: \n" + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel: \n" + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.optString("result");
            }
            throw new AVMRuntimeException("Contract method call failed. Reason: " + error);
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("Contract method call failed", (Exception)((Object)e));
        }
    }

    public String sendTransaction(String contract, String address, String callData, BigInteger value, long gas, long gasPrice) {
        try {
            this.log.info("Sending contract transaction  ...");
            JSONObject jo = this.getJsonHeader("eth_sendTransaction");
            ArrayList params = new ArrayList();
            JSONArray paramArray = new JSONArray();
            JSONObject txnJo = new JSONObject();
            txnJo.put("from", (Object)address);
            txnJo.put("to", (Object)contract);
            txnJo.put("gas", gas);
            txnJo.put("gasPrice", gasPrice);
            txnJo.put("data", (Object)("0x" + callData));
            if (value != null) {
                txnJo.put("value", (Object)value);
            }
            paramArray.put((Object)txnJo);
            jo.put("params", (Object)paramArray);
            this.log.info("Web3Rpc request data: \n" + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel : \n" + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.optString("result");
            }
            throw new AVMRuntimeException("Contract transaction failed. Reason: " + error);
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("Contract transaction failed", (Exception)((Object)e));
        }
    }

    public String sendDeployRawTransaction(String destination, String privateKey, String callData, BigInteger value, long gas, long gasPrice) {
        return this.sendRawTransaction(destination, privateKey, callData, value, gas, gasPrice, true);
    }

    public String sendRawTransaction(String destination, String privateKey, String callData, BigInteger value, long gas, long gasPrice) {
        return this.sendRawTransaction(destination, privateKey, callData, value, gas, gasPrice, false);
    }

    private String sendRawTransaction(String destination, String privateKey, String callData, BigInteger value, long gas, long gasPrice, boolean isAvmDeploy) {
        try {
            this.log.info("Signing transaction ...");
            String senderAddress = SignedTransactionBuilder.getAionAddress(privateKey);
            this.log.info("Sender address: " + senderAddress);
            String nonceHex = this.getTransactionCount(senderAddress);
            BigInteger nonce = BigInteger.ZERO;
            if (nonceHex != null) {
                nonce = ByteUtil.bytesToBigInteger(ByteUtil.hexStringToBytes(nonceHex));
            }
            this.log.info("Sender's nonce: " + nonce);
            Object signedTx = null;
            try {
                signedTx = SignedTransactionBuilder.signWithPvtKey(privateKey, destination, value, callData, nonce, gas, gasPrice, isAvmDeploy);
            }
            catch (Exception e) {
                throw new AVMRuntimeException("Txn signing failed ", e);
            }
            this.log.info("Sending raw contract transaction  ...");
            JSONObject jo = this.getJsonHeader("eth_sendRawTransaction");
            if (!((String)signedTx).startsWith("0x")) {
                signedTx = "0x" + (String)signedTx;
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(signedTx);
            JSONArray paramArray = new JSONArray();
            jo.put("params", params);
            this.log.info("Web3Rpc request data: \n" + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel: \n" + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.optString("result");
            }
            throw new AVMRuntimeException("Transaction failed. Reason: " + error);
        }
        catch (Exception e) {
            throw new AVMRuntimeException("Transaction failed", e);
        }
    }

    public String getTransactionCount(String address) {
        try {
            this.log.info("Get nonce ...");
            JSONObject jo = this.getJsonHeader("eth_getTransactionCount");
            ArrayList<String> params = new ArrayList<String>();
            params.add(address);
            params.add("latest");
            jo.put("params", params);
            this.log.info("Web3Rpc request data for getTransactionCount:\n " + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel for getTransactionCount: " + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.optString("result");
            }
            throw new AVMRuntimeException("Getting nonce for the address failed. Reason: " + error);
        }
        catch (Exception e) {
            throw new AVMRuntimeException("Getting nonce for the address failed. Reason: ", e);
        }
    }

    public String getBalance(String address) {
        try {
            JSONObject jo = this.getJsonHeader("eth_getBalance");
            ArrayList<String> params = new ArrayList<String>();
            params.add(address);
            params.add("latest");
            jo.put("params", params);
            this.log.info("Web3Rpc request data: \n" + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Get status code >>> " + jsonResponse.getStatus());
            }
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel: \n " + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.optString("result");
            }
            throw new AVMRuntimeException("get-balance failed. Reason: " + error);
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("Web3Rpc call failed for get balance", (Exception)((Object)e));
        }
    }

    public String transfer(String from, String to, BigInteger value, long gas, long gasPrice) {
        try {
            String nonceHex = this.getTransactionCount(from);
            BigInteger nonce = BigInteger.ZERO;
            if (nonceHex != null) {
                nonce = ByteUtil.bytesToBigInteger(ByteUtil.hexStringToBytes(nonceHex));
            }
            this.log.info("Sender's nonce: " + nonce);
            this.log.info("Sending transfer transaction  ...");
            JSONObject jo = this.getJsonHeader("eth_sendTransaction");
            ArrayList params = new ArrayList();
            JSONArray paramArray = new JSONArray();
            JSONObject txnJo = new JSONObject();
            txnJo.put("from", (Object)from);
            txnJo.put("to", (Object)to);
            txnJo.put("value", (Object)value);
            txnJo.put("gas", gas);
            txnJo.put("gasPrice", gasPrice);
            txnJo.put("nonce", (Object)nonceHex);
            txnJo.put("data", (Object)"");
            paramArray.put((Object)txnJo);
            jo.put("params", (Object)paramArray);
            this.log.info("Web3Rpc request data: \n" + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel: \n" + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.optString("result");
            }
            throw new AVMRuntimeException("Transfer transaction failed. Reason: " + error);
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("Transfer transaction failed", (Exception)((Object)e));
        }
    }

    public JSONObject getReceipt(String txHash) {
        try {
            JSONObject jo = this.getJsonHeader("eth_getTransactionReceipt");
            ArrayList<String> params = new ArrayList<String>();
            params.add(txHash);
            jo.put("params", params);
            this.log.info("Web3Rpc request data: \n" + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel: \n" + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject;
            }
            throw new AVMRuntimeException("getRecipt call failed. Reason: " + error);
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("getReceipt call failed", (Exception)((Object)e));
        }
    }

    public String createAccount(String password) {
        try {
            JSONObject jo = this.getJsonHeader("personal_newAccount");
            ArrayList<String> params = new ArrayList<String>();
            params.add(password);
            jo.put("params", params);
            this.log.info("Web3Rpc request data: \n" + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel: \n" + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.optString("result");
            }
            throw new AVMRuntimeException("New account creation failed: " + error);
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("New account creation failed", (Exception)((Object)e));
        }
    }

    public String getLogs(String fromBlock, String toBlock, String addresses, String topics, String blockHash) {
        try {
            JSONArray jsonArray;
            this.log.info("Getting logs");
            JSONObject jo = this.getJsonHeader("eth_getLogs");
            ArrayList<JSONObject> params = new ArrayList<JSONObject>();
            JSONObject filters = new JSONObject();
            if (fromBlock != null && !fromBlock.trim().isEmpty()) {
                filters.put("fromBlock", (Object)fromBlock);
            }
            if (toBlock != null && !toBlock.trim().isEmpty()) {
                filters.put("toBlock", (Object)toBlock);
            }
            if (addresses != null && !addresses.trim().isEmpty()) {
                String[] addArray = addresses.split(",");
                jsonArray = new JSONArray();
                for (String address : addArray) {
                    jsonArray.put((Object)address.trim());
                }
                filters.put("address", (Object)jsonArray);
            }
            if (topics != null && !topics.trim().isEmpty()) {
                String[] topicsArray = topics.split(",");
                jsonArray = new JSONArray();
                for (String topic : topicsArray) {
                    jsonArray.put((Object)topic);
                }
                filters.put("topics", (Object)jsonArray);
            }
            if (blockHash != null && !blockHash.isEmpty()) {
                filters.put("blockhash", (Object)blockHash);
            }
            params.add(filters);
            jo.put("params", params);
            this.log.info("Web3Rpc request data: \n" + jo.toString(2));
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            if (jsonNode == null) {
                return null;
            }
            this.log.info("Response from Aion kernel: \n" + jsonNode.getObject().toString(2));
            JSONObject jsonObject = jsonNode.getObject();
            String error = this.getError(jsonObject);
            if (error == null) {
                return jsonObject.toString();
            }
            throw new AVMRuntimeException("getLogs() failed. Reason: " + error);
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("getLogs() failed", (Exception)((Object)e));
        }
    }

    private String getError(JSONObject jsonObject) {
        JSONObject error = jsonObject.optJSONObject("error");
        if (error != null) {
            return error.toString();
        }
        return null;
    }

    public String getLatestBlock() {
        try {
            JSONObject jo = this.getJsonHeader("eth_blockNumber");
            jo.put("params", (Collection)Collections.EMPTY_LIST);
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            Object blockNumber = jsonNode.getObject().get("result");
            return blockNumber != null ? blockNumber.toString() : null;
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("Web3Rpc call failed to get latest block", (Exception)((Object)e));
        }
    }

    public String getGenesisBlockHash() {
        try {
            JSONObject jo = this.getJsonHeader("eth_getBlockByNumber");
            ArrayList<String> params = new ArrayList<String>();
            params.add("earliest");
            jo.put("params", params);
            HttpResponse jsonResponse = this.getHttpRequest().body(jo).asJson();
            JsonNode jsonNode = (JsonNode)jsonResponse.getBody();
            JSONObject result = (JSONObject)jsonNode.getObject().get("result");
            String blockHash = result.getString("hash");
            return blockHash;
        }
        catch (UnirestException e) {
            throw new AVMRuntimeException("Web3Rpc call failed to get genesis block hash", (Exception)((Object)e));
        }
    }

    private JSONObject getJsonHeader(String method) {
        JSONObject jo = new JSONObject();
        jo.put("id", (Object)this.generateRandomId());
        jo.put("jsonrpc", (Object)"2.0");
        jo.put("method", (Object)method);
        return jo;
    }

    private String generateRandomId() {
        Random rand = new Random();
        int randInt = rand.nextInt(1000000);
        return String.valueOf(randInt);
    }

    private HttpRequestWithBody getHttpRequest() {
        return Unirest.post((String)this.web3RpcUrl).header("accept", "application/json").header("Content-Type", "application/json");
    }
}

