/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.signing;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import org.aion.rlp.RLP;
import org.aion4j.avm.helper.signing.Blake2b;

public class SignedInvokableTransactionBuilder {
    private static final byte VERSION = 0;
    private static final byte AION_ADDRESS_PREFIX = -96;
    private String privateKey = null;
    private BigInteger nonce = null;
    private BigInteger value = null;
    private String destination = null;
    private String data = null;
    private String executor = null;

    public SignedInvokableTransactionBuilder privateKey(String privateKey) {
        this.privateKey = privateKey != null && privateKey.startsWith("0x") ? privateKey.substring(2) : privateKey;
        return this;
    }

    public SignedInvokableTransactionBuilder destination(String destination) {
        this.destination = destination != null && destination.startsWith("0x") ? destination.substring(2) : destination;
        return this;
    }

    public SignedInvokableTransactionBuilder value(BigInteger value) {
        this.value = value;
        return this;
    }

    public SignedInvokableTransactionBuilder senderNonce(BigInteger nonce) {
        this.nonce = nonce;
        return this;
    }

    public SignedInvokableTransactionBuilder data(String data) {
        this.data = data != null && data.startsWith("0x") ? data.substring(2) : data;
        return this;
    }

    public SignedInvokableTransactionBuilder executor(String executor) {
        this.executor = executor != null && executor.startsWith("0x") ? executor.substring(2) : executor;
        return this;
    }

    public byte[] buildSignedInvokableTransaction() throws InvalidKeySpecException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        if (this.privateKey == null) {
            throw new IllegalStateException("No private key specified.");
        }
        if (this.nonce == null) {
            throw new IllegalStateException("No nonce specified.");
        }
        EdDSAPrivateKey privateKey = new EdDSAPrivateKey(new PKCS8EncodedKeySpec(SignedInvokableTransactionBuilder.addSkPrefix(this.privateKey)));
        byte[] publicKey = privateKey.getAbyte();
        byte[] addrBytes = SignedInvokableTransactionBuilder.blake2b(publicKey);
        addrBytes[0] = -96;
        byte[] _to = this.destination == null ? new byte[]{} : Utils.hexToBytes((String)this.destination);
        byte[] _executor = this.executor == null ? new byte[]{} : Utils.hexToBytes((String)this.executor);
        byte[] encodedNonce = RLP.encodeBigInteger(this.nonce);
        byte[] encodedTo = RLP.encodeElement(_to);
        byte[] encodedValue = RLP.encodeBigInteger(this.value == null ? BigInteger.ZERO : this.value);
        byte[] encodedData = RLP.encodeElement(this.data == null ? new byte[]{} : Utils.hexToBytes((String)this.data));
        byte[] encodedExecutor = RLP.encodeElement(_executor);
        byte[] fullEncoding = RLP.encodeList(encodedNonce, encodedTo, encodedValue, encodedData, encodedExecutor);
        byte[] rawHash = SignedInvokableTransactionBuilder.blake2b(SignedInvokableTransactionBuilder.prependVersion(fullEncoding));
        byte[] signatureOnly = SignedInvokableTransactionBuilder.sign(privateKey, rawHash);
        byte[] preEncodeSignature = new byte[publicKey.length + signatureOnly.length];
        System.arraycopy(publicKey, 0, preEncodeSignature, 0, publicKey.length);
        System.arraycopy(signatureOnly, 0, preEncodeSignature, publicKey.length, signatureOnly.length);
        byte[] signature = RLP.encodeElement(preEncodeSignature);
        byte[] encoding = RLP.encodeList(encodedNonce, encodedTo, encodedValue, encodedData, encodedExecutor, signature);
        return SignedInvokableTransactionBuilder.prependVersion(encoding);
    }

    public static byte[] getTransactionHashOfSignedTransaction(byte[] signedTransaction) {
        if (signedTransaction == null) {
            throw new NullPointerException("cannot extract hash from a null transaction.");
        }
        if (signedTransaction[0] != 0) {
            throw new IllegalArgumentException("Hashing is only implemented for version code 0");
        }
        return SignedInvokableTransactionBuilder.blake2b(signedTransaction);
    }

    public void reset() {
        this.privateKey = null;
        this.nonce = null;
        this.value = null;
        this.destination = null;
        this.data = null;
        this.executor = null;
    }

    private static byte[] addSkPrefix(String skString) {
        String skEncoded;
        byte[] bytes;
        if (skString != null && skString.startsWith("0x")) {
            skString = skString.substring(2);
        }
        if ((bytes = Utils.hexToBytes((String)(skEncoded = "302e020100300506032b657004220420" + skString))).length > 48) {
            return Arrays.copyOfRange(bytes, 0, 48);
        }
        return bytes;
    }

    private static byte[] blake2b(byte[] msg) {
        Blake2b.Digest digest = Blake2b.Digest.newInstance(32);
        digest.update(msg);
        return digest.digest();
    }

    private static byte[] sign(EdDSAPrivateKey privateKey, byte[] data) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
        EdDSAEngine edDSAEngine = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
        edDSAEngine.initSign((PrivateKey)privateKey);
        return edDSAEngine.signOneShot(data);
    }

    private static byte[] prependVersion(byte[] encoding) {
        byte[] ret = new byte[encoding.length + 1];
        ret[0] = 0;
        System.arraycopy(encoding, 0, ret, 1, encoding.length);
        return ret;
    }
}

