/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.signing;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import org.aion.base.util.ByteUtil;
import org.aion.rlp.RLP;
import org.aion4j.avm.helper.signing.Blake2b;

public final class SignedTransactionBuilder {
    private static final byte AION_ADDRESS_PREFIX = -96;
    private String privateKey = null;
    private BigInteger nonce = null;
    private long energyLimit = -1L;
    private BigInteger value = null;
    private String destination = null;
    private String data = null;
    private long energyPrice = -1L;
    private byte type = 1;

    public SignedTransactionBuilder privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public SignedTransactionBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public SignedTransactionBuilder value(BigInteger value) {
        this.value = value;
        return this;
    }

    public SignedTransactionBuilder senderNonce(BigInteger nonce) {
        this.nonce = nonce;
        return this;
    }

    public SignedTransactionBuilder data(String data) {
        this.data = data;
        return this;
    }

    public SignedTransactionBuilder energyLimit(long limit) {
        this.energyLimit = limit;
        return this;
    }

    public SignedTransactionBuilder energyPrice(long price) {
        this.energyPrice = price;
        return this;
    }

    public SignedTransactionBuilder useAvmTransactionType() {
        this.type = (byte)2;
        return this;
    }

    public byte[] buildSignedTransaction() throws InvalidKeySpecException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        if (this.privateKey == null) {
            throw new IllegalStateException("No private key specified.");
        }
        if (this.nonce == null) {
            throw new IllegalStateException("No nonce specified.");
        }
        if (this.energyLimit == -1L) {
            throw new IllegalStateException("No energy limit specified.");
        }
        EdDSAPrivateKey privateKey = new EdDSAPrivateKey(new PKCS8EncodedKeySpec(SignedTransactionBuilder.addSkPrefix(this.privateKey)));
        byte[] publicKey = privateKey.getAbyte();
        byte[] addrBytes = SignedTransactionBuilder.blake2b(publicKey);
        addrBytes[0] = -96;
        byte[] to = this.destination == null ? new byte[]{} : Utils.hexToBytes((String)this.destination);
        byte[] value = this.value == null ? BigInteger.ZERO.toByteArray() : this.value.toByteArray();
        byte[] nonce = this.nonce.toByteArray();
        byte[] timestamp = BigInteger.valueOf(System.currentTimeMillis() * 1000L).toByteArray();
        byte[] encodedNonce = RLP.encodeElement(nonce);
        byte[] encodedTo = RLP.encodeElement(to);
        byte[] encodedValue = RLP.encodeElement(value);
        byte[] encodedData = RLP.encodeElement(this.data == null ? new byte[]{} : Utils.hexToBytes((String)this.data));
        byte[] encodedTimestamp = RLP.encodeElement(timestamp);
        byte[] encodedEnergy = RLP.encodeLong(this.energyLimit);
        byte[] encodedEnergyPrice = RLP.encodeLong(this.energyPrice == -1L ? 10000000000L : this.energyPrice);
        byte[] encodedType = RLP.encodeByte(this.type);
        byte[] fullEncoding = RLP.encodeList(encodedNonce, encodedTo, encodedValue, encodedData, encodedTimestamp, encodedEnergy, encodedEnergyPrice, encodedType);
        byte[] rawHash = SignedTransactionBuilder.blake2b(fullEncoding);
        byte[] signatureOnly = SignedTransactionBuilder.sign(privateKey, rawHash);
        byte[] preEncodeSignature = new byte[publicKey.length + signatureOnly.length];
        System.arraycopy(publicKey, 0, preEncodeSignature, 0, publicKey.length);
        System.arraycopy(signatureOnly, 0, preEncodeSignature, publicKey.length, signatureOnly.length);
        byte[] signature = RLP.encodeElement(preEncodeSignature);
        return RLP.encodeList(encodedNonce, encodedTo, encodedValue, encodedData, encodedTimestamp, encodedEnergy, encodedEnergyPrice, encodedType, signature);
    }

    public void reset() {
        this.privateKey = null;
        this.nonce = null;
        this.energyLimit = -1L;
        this.value = null;
        this.destination = null;
        this.data = null;
        this.energyPrice = -1L;
        this.type = 1;
    }

    private static byte[] addSkPrefix(byte[] skString) {
        byte[] skEncoded = Utils.hexToBytes((String)"302e020100300506032b657004220420");
        byte[] encoded = Arrays.copyOf(skEncoded, skEncoded.length + skString.length);
        System.arraycopy(skString, 0, encoded, skEncoded.length, skString.length);
        return encoded;
    }

    private static byte[] addSkPrefix(String skString) {
        String skEncoded;
        byte[] bytes;
        if (skString != null && skString.startsWith("0x")) {
            skString = skString.substring(2);
        }
        if ((bytes = Utils.hexToBytes((String)(skEncoded = "302e020100300506032b657004220420" + skString))).length > 48) {
            return Arrays.copyOfRange(bytes, 0, 48);
        }
        return bytes;
    }

    private static byte[] blake2b(byte[] msg) {
        Blake2b.Digest digest = Blake2b.Digest.newInstance(32);
        digest.update(msg);
        return digest.digest();
    }

    public static EdDSAPrivateKey getEDSAPrivateKey(String privateKey) throws InvalidKeySpecException {
        EdDSAPrivateKey key = new EdDSAPrivateKey(new PKCS8EncodedKeySpec(SignedTransactionBuilder.addSkPrefix(privateKey)));
        return key;
    }

    public static byte[] sign(EdDSAPrivateKey privateKey, byte[] data) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
        EdDSAEngine edDSAEngine = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
        edDSAEngine.initSign((PrivateKey)privateKey);
        return edDSAEngine.signOneShot(data);
    }

    private static byte hexToByte(String s) {
        return Utils.hexToBytes((String)s)[0];
    }

    public static String signWithPvtKey(String pvtKey, String to, BigInteger value, String callData, BigInteger nonce, long energy, long energyPrice, boolean isAvmDeploy) throws Exception {
        byte[] data;
        if (pvtKey != null && pvtKey.startsWith("0x")) {
            pvtKey = pvtKey.substring(2);
        }
        if (to != null && to.startsWith("0x")) {
            to = to.substring(2);
        }
        if (callData != null && callData.startsWith("0x")) {
            callData = callData.substring(2);
        }
        byte[] pb = Utils.hexToBytes((String)pvtKey);
        byte[] pvtKeyB = null;
        pvtKeyB = pb.length > 32 ? Arrays.copyOfRange(pb, 0, 32) : pb;
        byte[] toB = to == null ? new byte[]{} : Utils.hexToBytes((String)to);
        byte[] byArray = data = callData == null ? new byte[]{} : Utils.hexToBytes((String)callData);
        if (nonce == null) {
            nonce = BigInteger.ZERO;
        }
        SignedTransactionBuilder builder = new SignedTransactionBuilder();
        byte[] signedTx = null;
        signedTx = isAvmDeploy ? builder.privateKey(pvtKey).destination(to).value(value).data(callData).senderNonce(nonce).useAvmTransactionType().energyLimit(energy).energyPrice(energyPrice).buildSignedTransaction() : builder.privateKey(pvtKey).destination(to).value(value).data(callData).senderNonce(nonce).energyLimit(energy).energyPrice(energyPrice).buildSignedTransaction();
        return Utils.bytesToHex((byte[])signedTx);
    }

    public static String getAionAddress(String pvtKey) throws InvalidKeySpecException {
        byte[] pb = Utils.hexToBytes((String)pvtKey);
        byte[] pvtKeyB = null;
        pvtKeyB = pb.length > 32 ? Arrays.copyOfRange(pb, 0, 32) : pb;
        EdDSAPrivateKey privateKey = new EdDSAPrivateKey(new PKCS8EncodedKeySpec(SignedTransactionBuilder.addSkPrefix(pvtKey)));
        byte[] publicKey = privateKey.getAbyte();
        byte[] addrBytes = SignedTransactionBuilder.blake2b(publicKey);
        addrBytes[0] = SignedTransactionBuilder.hexToByte("a0");
        return ByteUtil.toHexStringWithPrefix(addrBytes);
    }

    public static void main(String[] args) throws Throwable {
        String pvtKey = "e9c9209f750f8be788834c2fb54a310ca77da2d264d27a4e6e46519ef5f2f878";
        String to = "a0c0cc973a306d31320fe72cad62afaa799d076bbd492ca4d5d5d941adfa12a9";
        String type = "";
        BigInteger value = BigInteger.valueOf(45L);
        String callData = " ";
        String tx = SignedTransactionBuilder.signWithPvtKey(pvtKey, to, new BigInteger("45"), "0x", null, 1000L, 100000L, false);
        System.out.println(tx);
    }
}

