/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.util;

import avm.Address;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.aion.avm.core.util.Helpers;
import org.aion4j.avm.helper.exception.MethodArgsParseException;
import org.aion4j.avm.helper.util.HexUtil;

public class MethodCallArgsUtil {
    public static Object[] parseMethodArgs(String argsString) throws Exception {
        if (argsString == null || argsString.isEmpty()) {
            return new Object[0];
        }
        String[] tokens = MethodCallArgsUtil.translateCommandline(argsString);
        ArrayList<Object> args = new ArrayList<Object>();
        boolean isType = false;
        String type = null;
        String prevType = null;
        ArrayList<String> tempHolder = null;
        for (String token : tokens) {
            isType = MethodCallArgsUtil.isType(token);
            if (isType) {
                type = token;
                if (tempHolder == null || tempHolder.size() == 0) {
                    tempHolder = new ArrayList<String>();
                    prevType = type;
                    continue;
                }
                if (tempHolder.size() == 1 && !MethodCallArgsUtil.isArrayType(prevType)) {
                    args.add(tempHolder.get(0));
                } else if (MethodCallArgsUtil.is2DArrayType(prevType)) {
                    args.add(MethodCallArgsUtil.get2DArray(prevType, tempHolder));
                } else {
                    args.add(MethodCallArgsUtil.getArray(prevType, tempHolder));
                }
                tempHolder.clear();
                prevType = type;
                continue;
            }
            if (MethodCallArgsUtil.is2DArrayType(type)) {
                tempHolder.add(token);
                continue;
            }
            Object value = MethodCallArgsUtil.convertStringToTypeObject(type, token);
            tempHolder.add((String)value);
        }
        if (tempHolder != null) {
            if (tempHolder.size() == 1 && !MethodCallArgsUtil.isArrayType(prevType)) {
                args.add(tempHolder.get(0));
            } else if (MethodCallArgsUtil.is2DArrayType(prevType)) {
                args.add(MethodCallArgsUtil.get2DArray(prevType, tempHolder));
            } else {
                args.add(MethodCallArgsUtil.getArray(prevType, tempHolder));
            }
        }
        return args.toArray();
    }

    private static boolean isArrayType(String type) {
        if (type == null) {
            return false;
        }
        return type.endsWith("[]");
    }

    private static boolean is2DArrayType(String type) {
        if (type == null) {
            return false;
        }
        return type.endsWith("[][]");
    }

    private static Object convertStringToTypeObject(String type, String token) throws MethodArgsParseException {
        if (type != null) {
            if (type.startsWith("-I")) {
                return Integer.parseInt(token);
            }
            if (type.startsWith("-J")) {
                return Long.valueOf(token);
            }
            if (type.startsWith("-K")) {
                return new BigInteger(token);
            }
            if (type.startsWith("-S")) {
                return Short.valueOf(token);
            }
            if (type.startsWith("-C")) {
                return Character.valueOf(token.charAt(0));
            }
            if (type.startsWith("-F")) {
                return Float.valueOf(token);
            }
            if (type.startsWith("-D")) {
                return Double.valueOf(token);
            }
            if (type.startsWith("-B")) {
                if (token.startsWith("0x")) {
                    return HexUtil.hexStringToBytes(token);
                }
                return Byte.valueOf(token);
            }
            if (type.startsWith("-Z")) {
                return Boolean.valueOf(token);
            }
            if (type.startsWith("-A")) {
                return new Address(Helpers.hexStringToBytes((String)token));
            }
            if (type.startsWith("-T")) {
                return token;
            }
            throw new MethodArgsParseException("Invalid type : " + type);
        }
        return null;
    }

    private static Object getArray(String type, List list) {
        if (type.startsWith("-I")) {
            return MethodCallArgsUtil.toIntArray(list);
        }
        if (type.startsWith("-J")) {
            return MethodCallArgsUtil.toLongArray(list);
        }
        if (type.startsWith("-K")) {
            return MethodCallArgsUtil.toBigIntegerArray(list);
        }
        if (type.startsWith("-S")) {
            return MethodCallArgsUtil.toShortArray(list);
        }
        if (type.startsWith("-C")) {
            return MethodCallArgsUtil.toCharArray(list);
        }
        if (type.startsWith("-F")) {
            return MethodCallArgsUtil.toFloatArray(list);
        }
        if (type.startsWith("-D")) {
            return MethodCallArgsUtil.toDoubleArray(list);
        }
        if (type.startsWith("-B")) {
            return MethodCallArgsUtil.toByteArray(list);
        }
        if (type.startsWith("-Z")) {
            return MethodCallArgsUtil.toBooleanArray(list);
        }
        if (type.startsWith("-A")) {
            Address[] objs = new Address[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                objs[i] = (Address)list.get(i);
            }
            return objs;
        }
        if (type.startsWith("-T")) {
            String[] objs = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                objs[i] = (String)list.get(i);
            }
            return objs;
        }
        return null;
    }

    private static Object get2DArray(String type, List list) throws MethodArgsParseException {
        if ("-B[][]".equals(type) && list != null && list.size() > 1 && list.get(0).toString().startsWith("0x")) {
            byte[][] bytes = null;
            for (int i = 0; i < list.size(); ++i) {
                String hexValue = (String)list.get(i);
                byte[] b = HexUtil.hexStringToBytes(hexValue);
                if (i == 0) {
                    bytes = new byte[list.size()][b.length];
                }
                bytes[i] = b;
            }
            return bytes;
        }
        int rows = list.size();
        int cols = MethodCallArgsUtil.parseRowElementsIn2DArray((String)list.get(0)).length;
        Object a2dObj = MethodCallArgsUtil.init2DArray(type, rows, cols);
        for (int i = 0; i < list.size(); ++i) {
            String rawString = (String)list.get(i);
            String[] tokens = MethodCallArgsUtil.parseRowElementsIn2DArray(rawString);
            ArrayList elmList = new ArrayList();
            for (int j = 0; j < tokens.length; ++j) {
                Object value = MethodCallArgsUtil.convertStringToTypeObject(type, tokens[j]);
                MethodCallArgsUtil.assignValueIn2DArray(type, a2dObj, i, j, value);
            }
        }
        return a2dObj;
    }

    private static String[] parseRowElementsIn2DArray(String rowStr) throws MethodArgsParseException {
        if (rowStr == null) {
            return new String[0];
        }
        String[] rowElms = null;
        rowElms = rowStr.contains(",") ? rowStr.split("\\s*,\\s*") : MethodCallArgsUtil.translateCommandline(rowStr);
        for (int i = 0; i < rowElms.length; ++i) {
            rowElms[i] = rowElms[i] != null ? rowElms[i].trim() : null;
        }
        return rowElms;
    }

    private static Object init2DArray(String type, int rows, int cols) {
        if (type.startsWith("-I[][]")) {
            return new int[rows][cols];
        }
        if (type.startsWith("-J[][]")) {
            return new long[rows][cols];
        }
        if (type.startsWith("-K[][]")) {
            return new BigInteger[rows][cols];
        }
        if (type.startsWith("-S[][]")) {
            return new short[rows][cols];
        }
        if (type.startsWith("-C[][]")) {
            return new char[rows][cols];
        }
        if (type.startsWith("-F[][]")) {
            return new float[rows][cols];
        }
        if (type.startsWith("-D[][]")) {
            return new double[rows][cols];
        }
        if (type.startsWith("-B[][]")) {
            return new byte[rows][cols];
        }
        if (type.startsWith("-Z[][]")) {
            return new boolean[rows][cols];
        }
        if (type.startsWith("-A[][]")) {
            return new Address[rows][cols];
        }
        if (type.startsWith("-T[][]")) {
            return new String[rows][cols];
        }
        return null;
    }

    private static void assignValueIn2DArray(String type, Object arr, int row, int col, Object value) {
        if (type.startsWith("-I[][]")) {
            ((int[][])arr)[row][col] = (Integer)value;
        } else if (type.startsWith("-J[][]")) {
            ((long[][])arr)[row][col] = (Long)value;
        } else if (type.startsWith("-K[][]")) {
            ((BigInteger[][])arr)[row][col] = (BigInteger)value;
        } else if (type.startsWith("-S[][]")) {
            ((short[][])arr)[row][col] = (Short)value;
        } else if (type.startsWith("-C[][]")) {
            ((char[][])arr)[row][col] = ((Character)value).charValue();
        } else if (type.startsWith("-F[][]")) {
            ((float[][])arr)[row][col] = ((Float)value).floatValue();
        } else if (type.startsWith("-D[][]")) {
            ((double[][])arr)[row][col] = (Double)value;
        } else if (type.startsWith("-B[][]")) {
            ((byte[][])arr)[row][col] = (Byte)value;
        } else if (type.startsWith("-Z[][]")) {
            ((boolean[][])arr)[row][col] = (Boolean)value;
        } else if (type.startsWith("-A[][]")) {
            ((Address[][])arr)[row][col] = (Address)value;
        } else if (type.startsWith("-T[][]")) {
            ((String[][])arr)[row][col] = (String)value;
        }
    }

    public static String[] translateCommandline(String toProcess) throws MethodArgsParseException {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        boolean inEscape = false;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' \\", true);
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        if (inEscape) {
                            current.append(nextTok);
                            inEscape = false;
                            continue block4;
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    inEscape = "\\".equals(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        if (inEscape) {
                            current.append(nextTok);
                            inEscape = false;
                            continue block4;
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    inEscape = "\\".equals(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                if (inEscape) {
                    inEscape = false;
                    current.append(nextTok);
                    continue;
                }
                state = 1;
                continue;
            }
            if ("\"".equals(nextTok)) {
                if (inEscape) {
                    inEscape = false;
                    current.append(nextTok);
                    continue;
                }
                state = 2;
                continue;
            }
            if (" ".equals(nextTok)) {
                if (current.length() == 0) continue;
                tokens.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(nextTok);
            inEscape = "\\".equals(nextTok);
        }
        if (current.length() != 0) {
            tokens.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new MethodArgsParseException("unbalanced quotes in " + toProcess);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static boolean isType(String token) {
        if (token == null) {
            return false;
        }
        switch (token) {
            case "-I": 
            case "-J": 
            case "-K": 
            case "-S": 
            case "-C": 
            case "-F": 
            case "-D": 
            case "-B": 
            case "-Z": 
            case "-A": 
            case "-T": 
            case "-I[]": 
            case "-J[]": 
            case "-K[]": 
            case "-S[]": 
            case "-C[]": 
            case "-F[]": 
            case "-D[]": 
            case "-B[]": 
            case "-Z[]": 
            case "-A[]": 
            case "-T[]": 
            case "-I[][]": 
            case "-J[][]": 
            case "-K[][]": 
            case "-S[][]": 
            case "-C[][]": 
            case "-F[][]": 
            case "-D[][]": 
            case "-B[][]": 
            case "-Z[][]": 
            case "-A[][]": 
            case "-T[][]": {
                return true;
            }
        }
        return false;
    }

    private static int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    private static long[] toLongArray(List<Long> list) {
        long[] ret = new long[list.size()];
        int i = 0;
        for (Long e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    private static BigInteger[] toBigIntegerArray(List<BigInteger> list) {
        BigInteger[] ret = new BigInteger[list.size()];
        int i = 0;
        for (BigInteger e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    private static short[] toShortArray(List<Short> list) {
        short[] ret = new short[list.size()];
        int i = 0;
        for (Short e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    private static char[] toCharArray(List<Character> list) {
        char[] ret = new char[list.size()];
        int i = 0;
        for (Character e : list) {
            ret[i++] = e.charValue();
        }
        return ret;
    }

    private static float[] toFloatArray(List<Float> list) {
        float[] ret = new float[list.size()];
        int i = 0;
        for (Float e : list) {
            ret[i++] = e.floatValue();
        }
        return ret;
    }

    private static double[] toDoubleArray(List<Double> list) {
        double[] ret = new double[list.size()];
        int i = 0;
        for (Double e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    private static byte[] toByteArray(List list) {
        if (list != null && list.size() == 1 && list.get(0) instanceof byte[]) {
            byte[] ret = (byte[])list.get(0);
            return ret;
        }
        byte[] ret = new byte[list.size()];
        int i = 0;
        for (Object e : list) {
            ret[i++] = (Byte)e;
        }
        return ret;
    }

    private static boolean[] toBooleanArray(List<Boolean> list) {
        boolean[] ret = new boolean[list.size()];
        int i = 0;
        for (Boolean e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    public static String print2DArray(Object data) {
        Class<?> clazz = data.getClass();
        if (clazz == byte[][].class) {
            byte[][] arr = (byte[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        if (clazz == boolean[][].class) {
            boolean[][] arr = (boolean[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        if (clazz == char[][].class) {
            char[][] arr = (char[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        if (clazz == short[][].class) {
            short[][] arr = (short[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        if (clazz == int[][].class) {
            int[][] arr = (int[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        if (clazz == long[][].class) {
            long[][] arr = (long[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        if (clazz == BigInteger[][].class) {
            BigInteger[][] arr = (BigInteger[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        if (clazz == float[][].class) {
            float[][] arr = (float[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        if (clazz == double[][].class) {
            double[][] arr = (double[][])data;
            return MethodCallArgsUtil.print2Darray(arr);
        }
        return null;
    }

    public static String printArray(Object data) {
        Class<?> clazz = data.getClass();
        if (clazz == byte[].class) {
            byte[] arr = (byte[])data;
            return Arrays.toString(arr);
        }
        if (clazz == boolean[].class) {
            boolean[] arr = (boolean[])data;
            return Arrays.toString(arr);
        }
        if (clazz == char[].class) {
            char[] arr = (char[])data;
            return Arrays.toString(arr);
        }
        if (clazz == short[].class) {
            short[] arr = (short[])data;
            return Arrays.toString(arr);
        }
        if (clazz == int[].class) {
            int[] arr = (int[])data;
            return Arrays.toString(arr);
        }
        if (clazz == long[].class) {
            long[] arr = (long[])data;
            return Arrays.toString(arr);
        }
        if (clazz == BigInteger[].class) {
            Object[] arr = (BigInteger[])data;
            return Arrays.toString(arr);
        }
        if (clazz == float[].class) {
            float[] arr = (float[])data;
            return Arrays.toString(arr);
        }
        if (clazz == double[].class) {
            double[] arr = (double[])data;
            return Arrays.toString(arr);
        }
        if (clazz == Address[].class) {
            Object[] arr = (Address[])data;
            return Arrays.toString(arr);
        }
        if (clazz == String[].class) {
            Object[] arr = (String[])data;
            return Arrays.toString(arr);
        }
        return null;
    }

    private static String print2Darray(byte[][] objs) {
        StringBuilder sb = new StringBuilder();
        for (byte[] arr : objs) {
            sb.append(Arrays.toString(arr));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String print2Darray(boolean[][] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        for (boolean[] arr : objs) {
            sb.append(Arrays.toString(arr));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String print2Darray(short[][] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        for (short[] arr : objs) {
            sb.append(Arrays.toString(arr));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String print2Darray(int[][] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        for (int[] arr : objs) {
            sb.append(Arrays.toString(arr));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String print2Darray(long[][] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        for (long[] arr : objs) {
            sb.append(Arrays.toString(arr));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String print2Darray(BigInteger[][] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        for (Object[] objectArray : objs) {
            sb.append(Arrays.toString(objectArray));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String print2Darray(char[][] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        for (char[] arr : objs) {
            sb.append(Arrays.toString(arr));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String print2Darray(float[][] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        for (float[] arr : objs) {
            sb.append(Arrays.toString(arr));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String print2Darray(double[][] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        for (double[] arr : objs) {
            sb.append(Arrays.toString(arr));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        Object[] objs;
        String argsStr = "-A 0x1122334455667788112233445566778811223344556677881122334455667788 -J 100 -I 45 -B -1 -T hello -K 50000000000000000000000";
        for (Object obj : objs = MethodCallArgsUtil.parseMethodArgs(argsStr)) {
            System.out.println(obj);
            System.out.println(obj.getClass());
        }
    }
}

