/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.avm.helper.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.avm.helper.util.StringUtils;

public class ResultCache {
    public static String statusFileName = ".aion4j.conf";
    public static String DEPLOY_ADDRESS = "deploy.address";
    public static String DEPLOY_TX_RECEIPT = "deploy.tx.receipt";
    public static String LAST_DEPLOY_DEBUG_ENABLE = "last.deploy.debug.enabled";
    public static String TX_RECEIPT = "last.tx.receipt";
    private String projectName;
    private String targetFolder;

    public ResultCache(String projectName, String targetFolder) {
        this.projectName = projectName;
        this.targetFolder = targetFolder;
    }

    public void updateDeployAddress(String address) {
        this.updateProperty(DEPLOY_ADDRESS, address);
        boolean debugEnabled = ConfigUtil.getAvmConfigurationBooleanProps("preserveDebuggability", false);
        this.updateDebugEnabledInLastDeploy(debugEnabled);
    }

    public void updateDeployTxnReceipt(String txHash) {
        this.updateProperty(DEPLOY_TX_RECEIPT, txHash);
        this.updateProperty(TX_RECEIPT, txHash);
        this.updateProperty(DEPLOY_ADDRESS, "");
    }

    private void updateDebugEnabledInLastDeploy(boolean flag2) {
        this.updateProperty(LAST_DEPLOY_DEBUG_ENABLE, String.valueOf(flag2));
    }

    public void updateTxnReceipt(String txHash) {
        this.updateProperty(TX_RECEIPT, txHash);
    }

    private void updateProperty(String propertyName, String address) {
        Properties props = this.readResults(this.targetFolder);
        if (props == null) {
            props = new Properties();
        }
        props.setProperty(this.resolvePropertyName(this.projectName, propertyName), address);
        this.writeResults(this.targetFolder, props);
    }

    public String getLastDeployedAddress() {
        return this.getPropertyValue(DEPLOY_ADDRESS);
    }

    public String getLastDeployTxnReceipt() {
        return this.getPropertyValue(DEPLOY_TX_RECEIPT);
    }

    public boolean getDebugEnabledInLastDeploy() {
        String flag2 = this.getPropertyValue(LAST_DEPLOY_DEBUG_ENABLE);
        if (StringUtils.isEmpty(flag2)) {
            return false;
        }
        return Boolean.parseBoolean(flag2);
    }

    public String getLastTxnReceipt() {
        return this.getPropertyValue(TX_RECEIPT);
    }

    private String getPropertyValue(String propertyName) {
        Properties props = this.readResults(this.targetFolder);
        if (props == null) {
            props = new Properties();
        }
        return props.getProperty(this.resolvePropertyName(this.projectName, propertyName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResults(String targetFolder, Properties props) {
        Properties prop = new Properties();
        OutputStream output = null;
        try {
            output = new FileOutputStream(new File(targetFolder, statusFileName));
            props.store(output, null);
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readResults(String targetFolder) {
        InputStream input = null;
        try {
            File deployResultFile = new File(targetFolder, statusFileName);
            if (!deployResultFile.exists()) {
                Properties properties = new Properties();
                return properties;
            }
            input = new FileInputStream(new File(targetFolder, statusFileName));
            Properties properties = new Properties();
            properties.load(input);
            Properties e = properties;
            return e;
        }
        catch (Exception io) {
            io.printStackTrace();
            Properties properties = new Properties();
            return properties;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String resolvePropertyName(String projectName, String propName) {
        return projectName + "." + propName;
    }
}

