/*
 * Decompiled with CFR 0.152.
 */
package org.ajbrown.namemachine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ajbrown.namemachine.Gender;
import org.ajbrown.namemachine.Name;
import org.ajbrown.namemachine.NameGeneratorOptions;

public class NameGenerator {
    private static final Logger LOG = Logger.getLogger(NameGenerator.class.getName());
    private static final String FEMALE_NAMES_FILE = "/org/ajbrown/namemachine/dist.female.first.txt";
    private static final String MALE_NAMES_FILE = "/org/ajbrown/namemachine/dist.male.first.txt";
    private static final String SURNAMES_FILE = "/org/ajbrown/namemachine/dist.all.last.txt";
    private final Random random = new Random();
    private final NameGeneratorOptions options;
    private TreeMap<Float, String> surnames;
    private TreeMap<Float, String> females;
    private TreeMap<Float, String> males;

    public NameGenerator() {
        this(new NameGeneratorOptions());
    }

    public NameGenerator(NameGeneratorOptions options) {
        this.options = options;
        try {
            this.surnames = this.loadNames(SURNAMES_FILE);
            this.females = this.loadNames(FEMALE_NAMES_FILE);
            this.males = this.loadNames(MALE_NAMES_FILE);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "IOException while loading names files.  You may not get any results!", e);
        }
    }

    public Name generateName() {
        return this.generateName(null);
    }

    public Name generateName(Gender gender) {
        if (gender == null) {
            gender = (double)(this.random.nextFloat() * 100.0f) <= this.options.getGenderWeight() ? Gender.FEMALE : Gender.MALE;
        }
        return new Name(this.pickName(gender == Gender.FEMALE ? this.females : this.males), this.pickName(this.surnames), gender);
    }

    public List<Name> generateNames(int count, Gender gender) {
        ArrayList<Name> names = new ArrayList<Name>(count);
        for (int i = 0; i < count; ++i) {
            names.add(this.generateName(gender));
        }
        return names;
    }

    public List<Name> generateNames(int count) {
        return this.generateNames(count, null);
    }

    private String pickName(TreeMap<Float, String> map) {
        assert (!map.isEmpty());
        Float key = null;
        while (key == null) {
            try {
                key = map.ceilingKey(Float.valueOf(this.random.nextFloat() * 100.0f));
            }
            catch (NullPointerException nullPointerException) {}
        }
        return map.get(key);
    }

    private TreeMap<Float, String> loadNames(String file) throws IOException {
        TreeMap<Float, String> names = new TreeMap<Float, String>();
        InputStream is = NameGenerator.class.getResourceAsStream(file);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = reader.readLine();
            while (line != null) {
                String[] fields = line.split("\\s+");
                names.put(Float.valueOf(Float.parseFloat(fields[2])), fields[0]);
                line = reader.readLine();
            }
        }
        return names;
    }
}

