/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.io.File;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.ajoberstar.grgit.Grgit;
import org.gradle.api.DefaultTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GitPublishCommit
extends DefaultTask {
    private final Property<Grgit> grgit;
    private final Property<String> message;
    private final Property<Boolean> sign;

    @Inject
    public GitPublishCommit(ObjectFactory objectFactory) {
        this.grgit = objectFactory.property(Grgit.class);
        this.message = objectFactory.property(String.class);
        this.sign = objectFactory.property(Boolean.class);
        this.getOutputs().upToDateWhen(t -> false);
    }

    @Internal
    public Property<Grgit> getGrgit() {
        return this.grgit;
    }

    @Input
    public Property<String> getMessage() {
        return this.message;
    }

    @Input
    @Optional
    public Property<Boolean> getSign() {
        return this.sign;
    }

    @OutputDirectory
    public File getRepoDirectory() {
        return ((Grgit)this.getGrgit().get()).getRepository().getRootDir();
    }

    @TaskAction
    public void commit() {
        Grgit git = (Grgit)this.getGrgit().get();
        git.add(op -> op.setPatterns(Stream.of(".").collect(Collectors.toSet())));
        if (git.status().isClean()) {
            this.setDidWork(false);
        } else {
            git.commit(op -> {
                op.setMessage((String)this.getMessage().get());
                if (this.getSign().isPresent()) {
                    op.setSign((Boolean)this.getSign().get());
                }
            });
            this.setDidWork(true);
        }
    }
}

