/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish;

import org.ajoberstar.gradle.git.publish.GitPublication;
import org.ajoberstar.gradle.git.publish.GitPublishExtension;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishCommit;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishPush;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishReset;
import org.ajoberstar.grgit.Grgit;
import org.ajoberstar.grgit.gradle.GrgitService;
import org.ajoberstar.grgit.gradle.GrgitServiceExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;

public class GitPublishPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        GitPublishExtension extension = (GitPublishExtension)project.getExtensions().create("gitPublish", GitPublishExtension.class, new Object[]{project});
        extension.getPublications().create("main");
        extension.getPublications().configureEach(publication -> {
            this.configurePublicationDefaults(project, (GitPublication)publication);
            Provider grgitService = project.getGradle().getSharedServices().registerIfAbsent(String.format("git-publish-%s-grgit", publication.getName()), GrgitService.class, spec -> {
                spec.parameters(parameters -> {
                    parameters.getDirectory().set((Provider)publication.getRepoDir());
                    parameters.getInitIfNotExists().set((Object)true);
                });
                spec.getMaxParallelUsages().set((Object)1);
            });
            TaskProvider<GitPublishReset> reset = this.createResetTask(project, (GitPublication)publication, (Provider<GrgitService>)grgitService);
            TaskProvider<Copy> copy = this.createCopyTask(project, (GitPublication)publication);
            TaskProvider<GitPublishCommit> commit = this.createCommitTask(project, (GitPublication)publication, (Provider<GrgitService>)grgitService);
            TaskProvider<GitPublishPush> push = this.createPushTask(project, (GitPublication)publication, (Provider<GrgitService>)grgitService);
            push.configure(t -> t.dependsOn(new Object[]{commit}));
            commit.configure(t -> t.dependsOn(new Object[]{copy}));
            copy.configure(t -> t.dependsOn(new Object[]{reset}));
        });
        project.getTasks().register("gitPublishPushAll", task -> {
            task.setGroup("publishing");
            task.setDescription("Pushes all publications to git");
            task.dependsOn(new Object[]{project.getTasks().withType(GitPublishPush.class)});
        });
    }

    private void configurePublicationDefaults(Project project, GitPublication publication) {
        publication.getCommitMessage().set((Object)"Generated by gradle-git-publish.");
        project.getPluginManager().withPlugin("org.ajoberstar.grgit.service", plugin -> {
            GrgitServiceExtension grgitExt = (GrgitServiceExtension)project.getExtensions().getByType(GrgitServiceExtension.class);
            publication.getRepoUri().set(grgitExt.getService().map(service -> this.getOriginUri(service.getGrgit())));
            publication.getReferenceRepoUri().set(grgitExt.getService().map(service -> service.getGrgit().getRepository().getRootDir().toURI().toString()));
        });
        publication.getRepoDir().set(project.getLayout().getBuildDirectory().dir("gitPublish/" + publication.getName()));
    }

    private TaskProvider<GitPublishReset> createResetTask(Project project, GitPublication publication, Provider<GrgitService> grgitService) {
        return project.getTasks().register(this.getTaskName(publication, "Reset"), GitPublishReset.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Prepares a git repo for " + publication.getName() + " publication content to be generated.");
            task.getGrgitService().set(grgitService);
            task.getRepoUri().set(publication.getRepoUri());
            task.getReferenceRepoUri().set(publication.getReferenceRepoUri());
            task.getBranch().set(publication.getBranch());
            task.setPreserve(publication.getPreserve());
        });
    }

    private TaskProvider<Copy> createCopyTask(Project project, GitPublication publication) {
        return project.getTasks().register(this.getTaskName(publication, "Copy"), Copy.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Copy " + publication.getName() + " publication contents to be published to git.");
            task.with(new CopySpec[]{publication.getContents()});
            task.into((Object)publication.getRepoDir());
            if (GradleVersion.version((String)"7.3").compareTo(GradleVersion.current()) <= 0) {
                task.doNotTrackState("Tracked by Git instead");
            }
        });
    }

    private TaskProvider<GitPublishCommit> createCommitTask(Project project, GitPublication publication, Provider<GrgitService> grgitService) {
        return project.getTasks().register(this.getTaskName(publication, "Commit"), GitPublishCommit.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Commits " + publication.getName() + " publication changes to be published to git.");
            task.getGrgitService().set(grgitService);
            task.getMessage().set(publication.getCommitMessage());
            task.getSign().set(publication.getSign());
        });
    }

    private TaskProvider<GitPublishPush> createPushTask(Project project, GitPublication publication, Provider<GrgitService> grgitService) {
        return project.getTasks().register(this.getTaskName(publication, "Push"), GitPublishPush.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Pushes " + publication.getName() + " publication changes to git.");
            task.getGrgitService().set(grgitService);
            task.getBranch().set(publication.getBranch());
        });
    }

    private String getOriginUri(Grgit grgit) {
        return grgit.getRemote().list().stream().filter(remote -> remote.getName().equals("origin")).map(remote -> remote.getUrl()).findAny().orElse(null);
    }

    private String getTaskName(GitPublication publication, String task) {
        if ("main".equals(publication.getName())) {
            return "gitPublish" + task;
        }
        String capitalizedName = publication.getName().substring(0, 1).toUpperCase() + publication.getName().substring(1);
        return "gitPublish" + capitalizedName + task;
    }
}

