/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.ajoberstar.grgit.Grgit;
import org.ajoberstar.grgit.gradle.GrgitService;
import org.eclipse.jgit.transport.URIish;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.util.PatternFilterable;

@UntrackedTask(because="Git tracks the state")
public class GitPublishReset
extends DefaultTask {
    private final Property<GrgitService> grgitService;
    private final Property<String> repoUri;
    private final Property<String> referenceRepoUri;
    private final Property<String> branch;
    private PatternFilterable preserve;
    private final ObjectFactory objectFactory;

    @Inject
    public GitPublishReset(ObjectFactory objectFactory) {
        this.grgitService = objectFactory.property(GrgitService.class);
        this.repoUri = objectFactory.property(String.class);
        this.referenceRepoUri = objectFactory.property(String.class);
        this.branch = objectFactory.property(String.class);
        this.objectFactory = objectFactory;
    }

    @Internal
    public Property<GrgitService> getGrgitService() {
        return this.grgitService;
    }

    @Internal
    public Property<String> getReferenceRepoUri() {
        return this.referenceRepoUri;
    }

    @Input
    public Property<String> getRepoUri() {
        return this.repoUri;
    }

    @Input
    public Property<String> getBranch() {
        return this.branch;
    }

    @Internal
    public PatternFilterable getPreserve() {
        return this.preserve;
    }

    public void setPreserve(PatternFilterable preserve) {
        this.preserve = preserve;
    }

    @TaskAction
    public void reset() throws IOException {
        Map remoteBranches;
        boolean remoteBranchExists;
        Map referenceBranches;
        boolean referenceBranchExists;
        String pubBranch;
        Grgit git = ((GrgitService)this.grgitService.get()).getGrgit();
        if (!this.isRemoteUriMatch(git, "origin", (String)this.repoUri.get())) {
            git.getRemote().remove(op -> op.setName("origin"));
            git.getRemote().add(op -> {
                op.setName("origin");
                op.setUrl((String)this.repoUri.get());
            });
        }
        if (this.referenceRepoUri.isPresent() && !this.isRemoteUriMatch(git, "reference", (String)this.referenceRepoUri.get())) {
            git.getRemote().remove(op -> op.setName("reference"));
            git.getRemote().add(op -> {
                op.setName("reference");
                op.setUrl((String)this.referenceRepoUri.get());
            });
        }
        if (!(pubBranch = (String)this.getBranch().get()).equals(git.getBranch().current().getName())) {
            git.checkout(op -> {
                op.setBranch((Object)pubBranch);
                op.setOrphan(true);
            });
        }
        if (this.referenceRepoUri.isPresent() && (referenceBranchExists = (referenceBranches = git.lsremote(op -> {
            op.setRemote("reference");
            op.setHeads(true);
        })).keySet().stream().anyMatch(ref -> ref.getFullName().equals("refs/heads/" + pubBranch)))) {
            this.getLogger().info("Fetching from reference repo: " + (String)this.referenceRepoUri.get());
            git.fetch(op -> {
                op.setRefSpecs(Arrays.asList(String.format("+refs/heads/%s:refs/remotes/reference/%s", pubBranch, pubBranch)));
                op.setTagMode("none");
            });
        }
        if (remoteBranchExists = (remoteBranches = git.lsremote(op -> {
            op.setRemote("origin");
            op.setHeads(true);
        })).keySet().stream().anyMatch(ref -> ref.getFullName().equals("refs/heads/" + pubBranch))) {
            git.fetch(op -> {
                this.getLogger().info("Fetching from remote repo: " + (String)this.repoUri.get());
                op.setRefSpecs(Arrays.asList(String.format("+refs/heads/%s:refs/remotes/origin/%s", pubBranch, pubBranch)));
                op.setTagMode("none");
            });
            if (!git.getBranch().list().stream().anyMatch(branch -> branch.getName().equals(pubBranch))) {
                git.getBranch().add(op -> {
                    op.setName(pubBranch);
                    op.setStartPoint((Object)("origin/" + pubBranch));
                });
            }
            git.clean(op -> {
                op.setDirectories(true);
                op.setIgnore(false);
            });
            git.checkout(op -> op.setBranch((Object)pubBranch));
            git.reset(op -> {
                op.setCommit((Object)("origin/" + pubBranch));
                op.setMode("hard");
            });
        }
        ConfigurableFileTree repoTree = this.objectFactory.fileTree();
        repoTree.from((Object)git.getRepository().getRootDir());
        FileTree preservedTree = repoTree.matching(this.getPreserve());
        FileTree unwantedTree = repoTree.minus((FileCollection)preservedTree).getAsFileTree();
        unwantedTree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                try {
                    Files.delete(fileVisitDetails.getFile().toPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        git.add(op -> {
            op.setPatterns(Stream.of(".").collect(Collectors.toSet()));
            op.setUpdate(true);
        });
    }

    private boolean isRemoteUriMatch(Grgit grgit, String remoteName, String remoteUri) {
        try {
            Optional<String> maybeCurrentRemoteUri = grgit.getRemote().list().stream().filter(remote -> remote.getName().equals(remoteName)).map(remote -> remote.getUrl()).findAny();
            if (maybeCurrentRemoteUri.isPresent()) {
                return new URIish(remoteUri).equals((Object)new URIish(maybeCurrentRemoteUri.get()));
            }
            return false;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI.", e);
        }
    }
}

