/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish;

import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class GitPublication
implements Named {
    private final String name;
    private final DirectoryProperty repoDir;
    private final Property<String> repoUri;
    private final Property<String> referenceRepoUri;
    private final Property<String> branch;
    private final Property<Integer> fetchDepth;
    private final Property<String> commitMessage;
    private final Property<Boolean> sign;
    private final CopySpec contents;
    private final PatternFilterable preserve;

    public GitPublication(String name, Project project, ObjectFactory objectFactory) {
        this.name = name;
        this.repoDir = objectFactory.directoryProperty();
        this.repoUri = objectFactory.property(String.class);
        this.referenceRepoUri = objectFactory.property(String.class);
        this.branch = objectFactory.property(String.class);
        this.fetchDepth = objectFactory.property(Integer.class);
        this.commitMessage = objectFactory.property(String.class);
        this.sign = objectFactory.property(Boolean.class);
        this.contents = project.copySpec();
        this.preserve = new PatternSet();
        this.preserve.include(new String[]{".git/**/*"});
    }

    public String getName() {
        return this.name;
    }

    public DirectoryProperty getRepoDir() {
        return this.repoDir;
    }

    public Property<String> getRepoUri() {
        return this.repoUri;
    }

    public Property<String> getReferenceRepoUri() {
        return this.referenceRepoUri;
    }

    public Property<String> getBranch() {
        return this.branch;
    }

    public Property<Integer> getFetchDepth() {
        return this.fetchDepth;
    }

    public Property<String> getCommitMessage() {
        return this.commitMessage;
    }

    public Property<Boolean> getSign() {
        return this.sign;
    }

    public CopySpec getContents() {
        return this.contents;
    }

    public void contents(Action<? super CopySpec> action) {
        action.execute((Object)this.contents);
    }

    public PatternFilterable getPreserve() {
        return this.preserve;
    }

    public void preserve(Action<? super PatternFilterable> action) {
        action.execute((Object)this.preserve);
    }
}

