/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.util.Arrays;
import javax.inject.Inject;
import org.ajoberstar.grgit.BranchStatus;
import org.ajoberstar.grgit.Grgit;
import org.ajoberstar.grgit.gradle.GrgitService;
import org.ajoberstar.grgit.operation.BranchChangeOp;
import org.gradle.api.DefaultTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;

@UntrackedTask(because="Git tracks the state")
public class GitPublishPush
extends DefaultTask {
    private final Property<GrgitService> grgitService;
    private final Property<String> branch;

    @Inject
    public GitPublishPush(ObjectFactory objectFactory) {
        this.grgitService = objectFactory.property(GrgitService.class);
        this.branch = objectFactory.property(String.class);
        this.onlyIf(t -> {
            try {
                Grgit git = ((GrgitService)this.getGrgitService().get()).getGrgit();
                BranchStatus status = git.getBranch().status(op -> op.setName(this.getBranch().get()));
                return status.getAheadCount() > 0;
            }
            catch (IllegalStateException e) {
                return true;
            }
        });
    }

    @Internal
    public Property<GrgitService> getGrgitService() {
        return this.grgitService;
    }

    @Input
    public Property<String> getBranch() {
        return this.branch;
    }

    @TaskAction
    public void push() {
        Grgit git = ((GrgitService)this.getGrgitService().get()).getGrgit();
        String pubBranch = (String)this.getBranch().get();
        git.push(op -> op.setRefsOrSpecs(Arrays.asList(String.format("refs/heads/%s:refs/heads/%s", pubBranch, pubBranch))));
        git.getBranch().change(op -> {
            op.setName(pubBranch);
            op.setStartPoint((Object)("origin/" + pubBranch));
            op.setMode(BranchChangeOp.Mode.TRACK);
        });
    }
}

