/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.Nullable;

public abstract class GitCliValueSource
implements ValueSource<String, Params> {
    @Inject
    protected abstract ExecOperations getExecOperations();

    @Nullable
    public String obtain() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.getExecOperations().exec(spec -> {
                spec.executable((Object)"git");
                spec.setArgs((List)((Params)this.getParameters()).getGitArguments().get());
                spec.setStandardOutput((OutputStream)output);
                spec.setErrorOutput(OutputStream.nullOutputStream());
            });
            return output.toString(StandardCharsets.UTF_8).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static interface Params
    extends ValueSourceParameters {
        public ListProperty<String> getGitArguments();
    }
}

