/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.process.ExecOperations;

@UntrackedTask(because="Git tracks the state")
public abstract class GitPublishCommit
extends DefaultTask {
    @OutputDirectory
    public abstract DirectoryProperty getRepoDir();

    @Input
    public abstract Property<String> getMessage();

    @Input
    @Optional
    public abstract Property<Boolean> getSign();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @TaskAction
    public void commit() {
        this.getExecOperations().exec(spec -> {
            spec.commandLine(new Object[]{"git", "add", "-A"});
            spec.workingDir(this.getRepoDir().get());
            spec.setStandardOutput(OutputStream.nullOutputStream());
        });
        ByteArrayOutputStream status = new ByteArrayOutputStream();
        this.getExecOperations().exec(spec -> {
            spec.commandLine(new Object[]{"git", "status", "--porcelain"});
            spec.workingDir(this.getRepoDir().get());
            spec.setStandardOutput((OutputStream)status);
        });
        if (status.toString(StandardCharsets.UTF_8).isEmpty()) {
            this.setDidWork(false);
            return;
        }
        this.getExecOperations().exec(spec -> {
            spec.executable((Object)"git");
            spec.args(new Object[]{"commit"});
            if (this.getSign().isPresent()) {
                spec.args(new Object[]{(Boolean)this.getSign().get() != false ? "--gpg-sign" : "--no-gpg-sign"});
            }
            spec.args(new Object[]{"--file", "-"});
            byte[] msg = ((String)this.getMessage().get()).getBytes(StandardCharsets.UTF_8);
            spec.setStandardInput((InputStream)new ByteArrayInputStream(msg));
            spec.workingDir(this.getRepoDir().get());
            spec.setStandardOutput(OutputStream.nullOutputStream());
        });
        this.setDidWork(true);
    }
}

