/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.process.ExecOperations;

@UntrackedTask(because="Git tracks the state")
public abstract class GitPublishPush
extends DefaultTask {
    @OutputDirectory
    public abstract DirectoryProperty getRepoDir();

    @Input
    public abstract Property<String> getBranch();

    @Internal
    public abstract Property<String> getUsername();

    @Internal
    public abstract Property<String> getPassword();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @TaskAction
    public void push() {
        String pubBranch = (String)this.getBranch().get();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.getExecOperations().exec(spec -> {
            String refSpec = String.format("refs/heads/%s:refs/heads/%s", pubBranch, pubBranch);
            spec.commandLine(new Object[]{"git", "push", "--porcelain", "--set-upstream", "origin", refSpec});
            if (this.getUsername().isPresent() && this.getPassword().isPresent()) {
                spec.environment("GIT_USERNAME", this.getUsername().get());
                spec.environment("GIT_PASSWORD", this.getPassword().get());
            }
            spec.workingDir(this.getRepoDir().get());
            spec.setStandardOutput((OutputStream)output);
        });
        String result = output.toString(StandardCharsets.UTF_8);
        this.setDidWork(!result.contains("[up to date]"));
    }
}

