/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.process.ExecOperations;

@UntrackedTask(because="Git tracks the state")
public abstract class GitPublishReset
extends DefaultTask {
    private PatternFilterable preserve;

    @OutputDirectory
    public abstract DirectoryProperty getRepoDir();

    @Internal
    public abstract Property<String> getReferenceRepoUri();

    @Input
    public abstract Property<String> getRepoUri();

    @Input
    public abstract Property<String> getBranch();

    @Input
    @Optional
    public abstract Property<Integer> getFetchDepth();

    @Internal
    public PatternFilterable getPreserve() {
        return this.preserve;
    }

    public void setPreserve(PatternFilterable preserve) {
        this.preserve = preserve;
    }

    @Internal
    public abstract Property<String> getUsername();

    @Internal
    public abstract Property<String> getPassword();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @TaskAction
    public void reset() throws IOException {
        boolean hasBranch;
        File repoDir = ((Directory)this.getRepoDir().get()).getAsFile();
        String pubBranch = (String)this.getBranch().get();
        if (!new File(repoDir, ".git").exists()) {
            this.getExecOperations().exec(spec -> {
                spec.commandLine(new Object[]{"git", "init", "--initial-branch=" + pubBranch});
                spec.workingDir((Object)repoDir);
                spec.setStandardOutput(OutputStream.nullOutputStream());
            });
        }
        if (this.getUsername().isPresent() && this.getPassword().isPresent()) {
            this.getExecOperations().exec(spec -> {
                String script = "!f() { echo username=$GIT_USERNAME; echo password=$GIT_PASSWORD; }; f";
                spec.commandLine(new Object[]{"git", "config", "--local", "credential.helper", script});
                spec.workingDir((Object)repoDir);
                spec.setStandardOutput(OutputStream.nullOutputStream());
            });
        }
        try {
            this.getExecOperations().exec(spec -> {
                spec.commandLine(new Object[]{"git", "remote", "add", "origin", this.getRepoUri().get()});
                spec.workingDir((Object)repoDir);
                spec.setStandardOutput(OutputStream.nullOutputStream());
                spec.setErrorOutput(OutputStream.nullOutputStream());
            });
        }
        catch (Exception e) {
            this.getExecOperations().exec(spec -> {
                spec.commandLine(new Object[]{"git", "remote", "set-url", "origin", this.getRepoUri().get()});
                spec.workingDir((Object)repoDir);
                spec.setStandardOutput(OutputStream.nullOutputStream());
            });
        }
        if (this.getReferenceRepoUri().isPresent() && !this.getFetchDepth().isPresent()) {
            Path repoObjectsPath = repoDir.toPath().resolve(".git").resolve("objects");
            Path alternatesPath = repoObjectsPath.resolve("info").resolve("alternates");
            Path referenceRepoPath = Path.of((String)this.getReferenceRepoUri().get(), new String[0]);
            Path referenceRepoGitPath = referenceRepoPath.resolve(".git");
            if (Files.exists(referenceRepoGitPath, new LinkOption[0])) {
                referenceRepoPath = referenceRepoGitPath;
            }
            Path referenceRepoShallowPath = referenceRepoPath.resolve("shallow");
            Path referenceRepoObjectsPath = referenceRepoPath.resolve("objects");
            if (Files.exists(referenceRepoShallowPath, new LinkOption[0])) {
                this.getLogger().info("Reference repo is shallow. Cannot use as a reference.");
            } else if (Files.exists(referenceRepoObjectsPath, new LinkOption[0])) {
                Files.writeString(alternatesPath, (CharSequence)(referenceRepoObjectsPath + "\n"), StandardCharsets.UTF_8, new OpenOption[0]);
            } else {
                this.getLogger().warn("Reference repo doesn't seem to have an objects database: {}", (Object)referenceRepoPath);
            }
        }
        try {
            this.getExecOperations().exec(spec -> {
                spec.commandLine(new Object[]{"git", "ls-remote", "--exit-code", "origin", pubBranch});
                spec.workingDir((Object)repoDir);
                if (this.getUsername().isPresent() && this.getPassword().isPresent()) {
                    spec.environment("GIT_USERNAME", this.getUsername().get());
                    spec.environment("GIT_PASSWORD", this.getPassword().get());
                }
                spec.setStandardOutput(OutputStream.nullOutputStream());
                spec.setErrorOutput(OutputStream.nullOutputStream());
            });
            hasBranch = true;
        }
        catch (Exception e) {
            hasBranch = false;
        }
        if (hasBranch) {
            this.getExecOperations().exec(spec -> {
                String refSpec = String.format("+refs/heads/%s:refs/remotes/origin/%s", pubBranch, pubBranch);
                spec.executable((Object)"git");
                spec.args(new Object[]{"fetch"});
                if (this.getFetchDepth().isPresent()) {
                    spec.args(new Object[]{"--depth", this.getFetchDepth().get()});
                }
                spec.args(new Object[]{"--no-tags"});
                spec.args(new Object[]{"origin", refSpec});
                if (this.getUsername().isPresent() && this.getPassword().isPresent()) {
                    spec.environment("GIT_USERNAME", this.getUsername().get());
                    spec.environment("GIT_PASSWORD", this.getPassword().get());
                }
                spec.workingDir((Object)repoDir);
                spec.setStandardOutput(OutputStream.nullOutputStream());
            });
            this.getExecOperations().exec(spec -> {
                spec.commandLine(new Object[]{"git", "switch", "--force-create", pubBranch, String.format("origin/%s", pubBranch)});
                spec.workingDir((Object)repoDir);
                spec.setStandardOutput(OutputStream.nullOutputStream());
                spec.setErrorOutput(OutputStream.nullOutputStream());
            });
        } else {
            this.getExecOperations().exec(spec -> {
                spec.commandLine(new Object[]{"git", "switch", "--orphan", pubBranch});
                spec.workingDir((Object)repoDir);
                spec.setStandardOutput(OutputStream.nullOutputStream());
                spec.setErrorOutput(OutputStream.nullOutputStream());
            });
        }
        this.getExecOperations().exec(spec -> {
            spec.commandLine(new Object[]{"git", "clean", "-fdx"});
            spec.workingDir((Object)repoDir);
            spec.setStandardOutput(OutputStream.nullOutputStream());
        });
        ConfigurableFileTree repoTree = this.getObjectFactory().fileTree();
        repoTree.from((Object)repoDir);
        FileTree preservedTree = repoTree.matching(this.getPreserve());
        FileTree unwantedTree = repoTree.minus((FileCollection)preservedTree).getAsFileTree();
        unwantedTree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                try {
                    Files.delete(fileVisitDetails.getFile().toPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        this.getExecOperations().exec(spec -> {
            spec.commandLine(new Object[]{"git", "add", "-A"});
            spec.workingDir((Object)repoDir);
            spec.setStandardOutput(OutputStream.nullOutputStream());
        });
    }
}

