/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import groovy.lang.Closure;
import org.ajoberstar.gradle.git.plugins.BasicPasswordCredentials;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.awtui.AwtCredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

public class GitPush
extends GitBase
implements AuthenticationSupported {
    private PasswordCredentials credentials = null;
    private Object remote = null;
    private boolean pushTags = false;
    private boolean pushAll = false;
    private boolean force = false;

    @TaskAction
    public void push() {
        PushCommand cmd = this.getGit().push();
        cmd.setCredentialsProvider(this.getCredentialsProvider());
        cmd.setRemote(this.getRemote());
        if (this.isPushTags()) {
            cmd.setPushTags();
        }
        if (this.isPushAll()) {
            cmd.setPushAll();
        }
        cmd.setForce(this.isForce());
        try {
            cmd.call();
        }
        catch (Exception e) {
            throw new GradleException("Problem pushing to repository.", (Throwable)e);
        }
    }

    @Input
    @Optional
    public PasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Closure closure) {
        if (this.getCredentials() == null) {
            this.setCredentials(new BasicPasswordCredentials());
        }
        ConfigureUtil.configure((Closure)closure, (Object)this.getCredentials());
    }

    public void setCredentials(PasswordCredentials credentials) {
        this.credentials = credentials;
    }

    private CredentialsProvider getCredentialsProvider() {
        PasswordCredentials creds = this.getCredentials();
        if (creds != null && creds.getUsername() != null && creds.getPassword() != null) {
            return new UsernamePasswordCredentialsProvider(creds.getUsername(), creds.getPassword());
        }
        return new AwtCredentialsProvider();
    }

    @Input
    public String getRemote() {
        return this.remote == null ? "origin" : ObjectUtil.unpackString(this.remote);
    }

    public void setRemote(Object remote) {
        this.remote = remote;
    }

    @Input
    public boolean isPushTags() {
        return this.pushTags;
    }

    public void setPushTags(boolean pushTags) {
        this.pushTags = pushTags;
    }

    @Input
    public boolean isPushAll() {
        return this.pushAll;
    }

    public void setPushAll(boolean pushAll) {
        this.pushAll = pushAll;
    }

    @Input
    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

