/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import java.io.IOException;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.merge.MergeStrategy;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class GitMerge
extends GitBase {
    private Object strategy = null;
    private Object ref = null;

    @TaskAction
    public void merge() {
        MergeCommand cmd = this.getGit().merge();
        cmd.include((AnyObjectId)this.findRef());
        cmd.setStrategy(this.getMergeStrategy());
        try {
            cmd.call();
        }
        catch (CheckoutConflictException e) {
            throw new GradleException("The working tree changes conflict with the specified commit.", (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem with merge.", (Throwable)e);
        }
    }

    @Input
    public String getRef() {
        if (this.ref == null) {
            return null;
        }
        return ObjectUtil.unpackString(this.ref);
    }

    public void setRef(Object ref) {
        this.ref = ref;
    }

    @Input
    @Optional
    public Object getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Object mode) {
        this.strategy = mode;
    }

    private MergeStrategy getMergeStrategy() {
        String modeConfig = ObjectUtil.unpackString(this.getStrategy());
        if (modeConfig == null) {
            return MergeStrategy.RESOLVE;
        }
        try {
            return MergeStrategy.get((String)modeConfig.toUpperCase());
        }
        catch (Exception e) {
            throw new GradleException("No valid merge strategy could be identified from the specified input: " + modeConfig, (Throwable)e);
        }
    }

    private ObjectId findRef() {
        String ref = this.getRef();
        if (ref == null) {
            throw new GradleException("Invalid ref specified");
        }
        try {
            ObjectId commitId = this.getGit().getRepository().resolve(ref + "^{commit}");
            if (commitId == null) {
                throw new GradleException("No valid commit could be identified from the specified ref: " + ref);
            }
            return commitId;
        }
        catch (IOException e) {
            throw new GradleException("Unable to identify a commit from the specified ref: " + ref, (Throwable)e);
        }
    }
}

