/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import groovy.lang.Closure;
import org.ajoberstar.gradle.git.auth.BasicPasswordCredentials;
import org.ajoberstar.gradle.git.auth.JGitCredentialsProviderSupport;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

public class GitPull
extends GitBase
implements AuthenticationSupported {
    private PasswordCredentials credentials = new BasicPasswordCredentials();
    private JGitCredentialsProviderSupport credsProviderSupport = new JGitCredentialsProviderSupport(this);

    @TaskAction
    public void pullRepo() {
        PullCommand cmd = this.getGit().pull();
        cmd.setCredentialsProvider(this.credsProviderSupport.getCredentialsProvider());
        try {
            cmd.call();
        }
        catch (InvalidRemoteException e) {
            throw new GradleException("Invalid remote repository.", (Throwable)e);
        }
        catch (TransportException e) {
            throw new GradleException("Problem with transport.", (Throwable)e);
        }
        catch (WrongRepositoryStateException e) {
            throw new GradleException("Invalid repository state.", (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem with pull.", (Throwable)e);
        }
    }

    @Input
    @Optional
    public PasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getCredentials());
    }

    public void setCredentials(PasswordCredentials credentials) {
        this.credentials = credentials;
    }
}

