/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ajoberstar.gradle.git.api.Commit;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.git.util.GitUtil;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class GitLog
extends GitBase {
    private List<String> includes;
    private List<String> excludes;
    private int skipCommits = 0;
    private int maxCommits = -1;
    private List<Commit> log;

    @TaskAction
    public void reset() {
        ObjectId commit;
        LogCommand cmd = this.getGit().log();
        Repository repo = this.getGit().getRepository();
        if (this.includes != null) {
            for (String include : this.includes) {
                try {
                    commit = repo.resolve(include);
                    if (commit == null) {
                        throw new GradleException("No commit found for revision string: " + include);
                    }
                    cmd.add((AnyObjectId)commit);
                }
                catch (AmbiguousObjectException e) {
                    throw new GradleException("Revision string is ambiguous: " + include, (Throwable)e);
                }
                catch (MissingObjectException e) {
                    throw new GradleException("Commit could not be found in repository: " + include, (Throwable)e);
                }
                catch (IncorrectObjectTypeException e) {
                    throw new GradleException("Revision string did not point to a commit: " + include, (Throwable)e);
                }
                catch (IOException e) {
                    throw new GradleException("Problem resolving revision string: " + include, (Throwable)e);
                }
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                try {
                    commit = repo.resolve(exclude);
                    if (commit == null) {
                        throw new GradleException("No commit found for revision string: " + exclude);
                    }
                    cmd.add((AnyObjectId)commit);
                }
                catch (AmbiguousObjectException e) {
                    throw new GradleException("Revision string is ambiguous: " + exclude, (Throwable)e);
                }
                catch (MissingObjectException e) {
                    throw new GradleException("Commit could not be found in repository: " + exclude, (Throwable)e);
                }
                catch (IncorrectObjectTypeException e) {
                    throw new GradleException("Revision string did not point to a commit: " + exclude, (Throwable)e);
                }
                catch (IOException e) {
                    throw new GradleException("Problem resolving revision string: " + exclude, (Throwable)e);
                }
            }
        }
        cmd.setSkip(this.skipCommits);
        cmd.setMaxCount(this.maxCommits);
        try {
            Iterable commits = cmd.call();
            ArrayList<Commit> tempLog = new ArrayList<Commit>();
            for (RevCommit commit2 : commits) {
                tempLog.add(GitUtil.revCommitToCommit(commit2));
            }
            this.log = Collections.unmodifiableList(tempLog);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem with log.", (Throwable)e);
        }
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void include(String ... includes) {
        if (this.includes == null) {
            this.includes = new ArrayList<String>(includes.length);
        }
        Collections.addAll(this.includes, includes);
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void exclude(String ... excludes) {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>(excludes.length);
        }
        Collections.addAll(this.excludes, excludes);
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void includeRange(String since, String until) {
        this.include(until);
        this.exclude(since);
    }

    @Input
    public int getSkipCommits() {
        return this.skipCommits;
    }

    public void setSkipCommits(int skipCommits) {
        this.skipCommits = skipCommits;
    }

    @Input
    public int getMaxCommits() {
        return this.maxCommits;
    }

    public void setMaxCommits(int maxCommits) {
        this.maxCommits = maxCommits;
    }

    public List<Commit> getLog() {
        if (this.log == null) {
            throw new IllegalStateException("Task has not executed yet.");
        }
        return this.log;
    }
}

