/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import org.ajoberstar.gradle.git.tasks.GitBase;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class GitBranchCreate
extends GitBase {
    private String branchName;
    private String startPoint = "master";
    private Mode mode;
    private boolean force = false;

    @TaskAction
    void branchCreate() {
        CreateBranchCommand cmd = this.getGit().branchCreate();
        cmd.setName(this.getBranchName());
        cmd.setStartPoint(this.getStartPoint());
        cmd.setForce(this.getForce());
        if (this.getMode() != null) {
            switch (this.getMode()) {
                case NO_TRACK: {
                    cmd.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK);
                    break;
                }
                case TRACK: {
                    cmd.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
                    break;
                }
                case SET_UPSTREAM: {
                    cmd.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Illegal mode: " + (Object)((Object)this.getMode())));
                }
            }
        }
        try {
            cmd.call();
        }
        catch (InvalidRefNameException e) {
            throw new GradleException("Invalid branch name: " + this.getName(), (Throwable)e);
        }
        catch (RefNotFoundException e) {
            throw new GradleException("Can't find start point: " + this.getStartPoint(), (Throwable)e);
        }
        catch (RefAlreadyExistsException e) {
            throw new GradleException("Branch " + this.getName() + " already exists. Use force=true to modify.", (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem creating or updating branch " + this.getName(), (Throwable)e);
        }
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(String startPoint) {
        this.startPoint = startPoint;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public static enum Mode {
        NO_TRACK,
        TRACK,
        SET_UPSTREAM;

    }
}

