/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import org.ajoberstar.gradle.git.tasks.GitSource;
import org.eclipse.jgit.api.CheckoutCommand;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.TaskAction;

public class GitCheckout
extends GitSource {
    private String startPoint;
    private String branchName = "master";
    private boolean createBranch = false;

    @TaskAction
    void checkout() {
        final CheckoutCommand cmd = this.getGit().checkout();
        cmd.setStartPoint(this.startPoint);
        cmd.setName(this.branchName);
        cmd.setCreateBranch(this.createBranch);
        if (!this.patternSet.getExcludes().isEmpty() || !this.patternSet.getIncludes().isEmpty()) {
            this.getSource().visit(new FileVisitor(){

                public void visitDir(FileVisitDetails arg0) {
                    this.visitFile(arg0);
                }

                public void visitFile(FileVisitDetails arg0) {
                    cmd.addPath(arg0.getPath());
                }
            });
        }
        try {
            cmd.call();
        }
        catch (Exception e) {
            throw new GradleException("Problem checking out from repository", (Throwable)e);
        }
    }

    public String getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(String startPoint) {
        this.startPoint = startPoint;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public boolean getCreateBranch() {
        return this.createBranch;
    }

    public void setCreateBranch(boolean createBranch) {
        this.createBranch = createBranch;
    }
}

