/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.ajoberstar.gradle.git.auth.BasicPasswordCredentials;
import org.ajoberstar.gradle.git.auth.TransportAuthUtil;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitClone
extends DefaultTask
implements AuthenticationSupported {
    private static final String BRANCH_ROOT = "refs/heads/";
    private static final String TAG_ROOT = "refs/tags/";
    private PasswordCredentials credentials = new BasicPasswordCredentials();
    private Object uri = null;
    private Object remote = null;
    private boolean bare = false;
    private boolean checkout = true;
    private Object ref = null;
    private Collection<Object> branchesToClone = null;
    private boolean cloneAllBranches = true;
    private Object destinationPath = null;

    @TaskAction
    public void cloneRepo() {
        CloneCommand cmd = Git.cloneRepository();
        TransportAuthUtil.configure((TransportCommand)cmd, this);
        cmd.setURI(this.getUri().toString());
        cmd.setRemote(this.getRemote());
        cmd.setBare(this.getBare());
        cmd.setNoCheckout(!this.getCheckout());
        cmd.setBranch(this.getRef());
        cmd.setBranchesToClone(this.getBranchesToClone());
        cmd.setCloneAllBranches(this.getCloneAllBranches());
        cmd.setDirectory(this.getDestinationDir());
        try {
            cmd.call();
        }
        catch (InvalidRemoteException e) {
            throw new GradleException("Invalid remote specified: " + this.getRemote(), (Throwable)e);
        }
        catch (TransportException e) {
            throw new GradleException("Problem with transport.", (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem with clone.", (Throwable)e);
        }
    }

    @Input
    @Optional
    public PasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getCredentials());
    }

    public void setCredentials(PasswordCredentials credentials) {
        this.credentials = credentials;
    }

    @Input
    public String getUri() {
        return ObjectUtil.unpackString(this.uri);
    }

    public void setUri(Object uri) {
        this.uri = uri;
    }

    @Input
    public String getRemote() {
        return this.remote == null ? "origin" : ObjectUtil.unpackString(this.remote);
    }

    public void setRemote(Object remote) {
        this.remote = remote;
    }

    @Input
    public boolean getBare() {
        return this.bare;
    }

    public void setBare(boolean bare) {
        this.bare = bare;
    }

    @Input
    public boolean getCheckout() {
        return this.checkout;
    }

    public void setCheckout(boolean checkout) {
        this.checkout = checkout;
    }

    @Input
    public String getRef() {
        return this.ref == null ? "refs/heads/master" : ObjectUtil.unpackString(this.ref);
    }

    public void setRef(Object ref) {
        this.ref = ref;
    }

    public String getBranch() {
        String ref = this.getRef();
        return ref.startsWith(BRANCH_ROOT) ? ref.substring(BRANCH_ROOT.length()) : null;
    }

    public void setBranch(final Object branch) {
        this.ref = new Callable<String>(){

            @Override
            public String call() {
                return GitClone.BRANCH_ROOT + ObjectUtil.unpackString(branch);
            }
        };
    }

    public String getTag() {
        String ref = this.getRef();
        return ref.startsWith(TAG_ROOT) ? ref.substring(TAG_ROOT.length()) : null;
    }

    public void setTag(final Object tag) {
        this.ref = new Callable<String>(){

            @Override
            public String call() {
                return GitClone.TAG_ROOT + ObjectUtil.unpackString(tag);
            }
        };
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.getProject().file(this.destinationPath);
    }

    public void setDestinationPath(Object destinationPath) {
        this.destinationPath = destinationPath;
    }

    @Input
    public Collection<String> getBranchesToClone() {
        if (this.branchesToClone == null) {
            return Arrays.asList(this.getBranch());
        }
        HashSet<String> branches = new HashSet<String>();
        for (Object branch : this.branchesToClone) {
            branches.add(ObjectUtil.unpackString(branch));
        }
        return branches;
    }

    public void branchesToClone(Object ... branches) {
        if (this.branchesToClone == null) {
            this.branchesToClone = new ArrayList<Object>();
        }
        Collections.addAll(this.branchesToClone, branches);
    }

    public void setBranchesToClone(Collection<? extends Object> branchesToClone) {
        this.branchesToClone = branchesToClone;
        this.setCloneAllBranches(false);
    }

    @Input
    public boolean getCloneAllBranches() {
        return this.cloneAllBranches;
    }

    public void setCloneAllBranches(boolean cloneAllBranches) {
        this.cloneAllBranches = cloneAllBranches;
    }
}

