/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import groovy.lang.Closure;
import org.ajoberstar.gradle.git.tasks.GitSource;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.lib.PersonIdent;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

public class GitCommit
extends GitSource {
    private Object message = null;
    private boolean commitAll = false;
    private PersonIdent committer = null;
    private PersonIdent author = null;

    @TaskAction
    public void commit() {
        final CommitCommand cmd = this.getGit().commit();
        cmd.setMessage(this.getMessage());
        cmd.setAll(this.getCommitAll());
        if (this.committer != null) {
            cmd.setCommitter(this.getCommitter());
        }
        if (this.author != null) {
            cmd.setAuthor(this.getAuthor());
        }
        if (!this.patternSet.getExcludes().isEmpty() || !this.patternSet.getIncludes().isEmpty()) {
            this.getSource().visit(new FileVisitor(){

                public void visitDir(FileVisitDetails arg0) {
                    this.visitFile(arg0);
                }

                public void visitFile(FileVisitDetails arg0) {
                    cmd.setOnly(arg0.getPath());
                }
            });
        }
        try {
            cmd.call();
        }
        catch (Exception e) {
            throw new GradleException("Problem committing changes.", (Throwable)e);
        }
    }

    @Input
    public String getMessage() {
        return ObjectUtil.unpackString(this.message);
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    @Input
    public boolean getCommitAll() {
        return this.commitAll;
    }

    public void setCommitAll(boolean commitAll) {
        this.commitAll = commitAll;
    }

    @Input
    @Optional
    public PersonIdent getCommitter() {
        return this.committer;
    }

    public void setCommitter(PersonIdent committer) {
        this.committer = committer;
    }

    public void committer(Closure config) {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.getGit().getRepository());
        }
        ConfigureUtil.configure((Closure)config, (Object)this.committer);
    }

    @Input
    @Optional
    public PersonIdent getAuthor() {
        return this.author;
    }

    public void setAuthor(PersonIdent author) {
        this.author = author;
    }

    public void author(Closure config) {
        if (this.author == null) {
            this.author = new PersonIdent(this.getGit().getRepository());
        }
        ConfigureUtil.configure((Closure)config, (Object)this.author);
    }
}

