/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.auth;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JschAgentProxySessionFactory
extends JschConfigSessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(JschAgentProxySessionFactory.class);

    protected void configure(OpenSshConfig.Host hc, Session session) {
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        JSch jsch = super.getJSch(hc, fs);
        Connector con = this.determineConnector();
        if (con != null) {
            jsch.setIdentityRepository((IdentityRepository)new RemoteIdentityRepository(con));
        }
        return jsch;
    }

    private Connector determineConnector() {
        try {
            if (SSHAgentConnector.isConnectorAvailable()) {
                logger.info("ssh-agent available");
                JNAUSocketFactory usf = new JNAUSocketFactory();
                return new SSHAgentConnector((USocketFactory)usf);
            }
            if (PageantConnector.isConnectorAvailable()) {
                logger.info("pageant available");
                return new PageantConnector();
            }
            logger.info("jsch agent proxy not available");
            return null;
        }
        catch (AgentProxyException e) {
            logger.debug("Could not configure JSCH agent proxy connector.", (Throwable)e);
            return null;
        }
    }
}

