/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitReset
extends GitBase {
    private Object mode = null;
    private Object ref = null;
    private List<Object> paths = null;

    @TaskAction
    public void reset() {
        ResetCommand cmd = this.getGit().reset();
        cmd.setRef(this.getRef());
        cmd.setMode(this.getResetType());
        List<String> pathsToReset = this.getPaths();
        for (String path : pathsToReset) {
            cmd.addPath(path);
        }
        try {
            cmd.call();
        }
        catch (CheckoutConflictException e) {
            throw new GradleException("The working tree changes conflict with the specified commit.", (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem with reset.", (Throwable)e);
        }
    }

    @Input
    public String getRef() {
        return this.ref == null ? "HEAD" : ObjectUtil.unpackString(this.ref);
    }

    public void setRef(Object ref) {
        this.ref = ref;
    }

    @Input
    public List<String> getPaths() {
        if (this.paths == null) {
            return Collections.emptyList();
        }
        ArrayList<String> resetPaths = new ArrayList<String>();
        for (Object path : this.paths) {
            resetPaths.add(ObjectUtil.unpackString(path));
        }
        return resetPaths;
    }

    public void paths(Object ... resetPaths) {
        if (this.paths == null) {
            this.paths = new ArrayList<Object>();
        }
        Collections.addAll(this.paths, resetPaths);
    }

    public void setPaths(List<? extends Object> resetPaths) {
        this.paths = resetPaths;
    }

    @Input
    @Optional
    public Object getMode() {
        return this.mode;
    }

    public void setMode(Object mode) {
        this.mode = mode;
    }

    private ResetCommand.ResetType getResetType() {
        String modeConfig = ObjectUtil.unpackString(this.getMode());
        if (modeConfig == null) {
            if (this.paths == null || this.paths.size() == 0) {
                throw new GradleException("No reset mode and no file path has been specified. One of the them is needed to complete the reset");
            }
            return null;
        }
        try {
            return ResetCommand.ResetType.valueOf((String)modeConfig.toUpperCase());
        }
        catch (Exception e) {
            throw new GradleException("No valid reset mode could be identified from the specified input: " + modeConfig, (Throwable)e);
        }
    }
}

