/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import java.util.Set;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitStatus
extends GitBase {
    private Status status;

    @TaskAction
    public void status() {
        StatusCommand cmd = this.getGit().status();
        try {
            this.status = cmd.call();
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem obtaining status", (Throwable)e);
        }
    }

    public FileCollection getAdded() {
        this.assertComplete();
        return this.toFiles(this.status.getAdded());
    }

    public FileCollection getChanged() {
        this.assertComplete();
        return this.toFiles(this.status.getChanged());
    }

    public FileCollection getConflicting() {
        this.assertComplete();
        return this.toFiles(this.status.getConflicting());
    }

    public FileCollection getIgnored() {
        this.assertComplete();
        return this.toFiles(this.status.getIgnoredNotInIndex());
    }

    public FileCollection getMissing() {
        this.assertComplete();
        return this.toFiles(this.status.getMissing());
    }

    public FileCollection getModified() {
        this.assertComplete();
        return this.toFiles(this.status.getModified());
    }

    public FileCollection getRemoved() {
        this.assertComplete();
        return this.toFiles(this.status.getRemoved());
    }

    public FileCollection getUntracked() {
        this.assertComplete();
        return this.toFiles(this.status.getUntracked());
    }

    public FileCollection getUntrackedDirs() {
        this.assertComplete();
        return this.toFiles(this.status.getUntrackedFolders());
    }

    private FileCollection toFiles(Set<String> paths) {
        return ((ProjectInternal)this.getProject()).getFileResolver().withBaseDir((Object)this.getRepoDir()).resolveFiles(new Object[]{paths});
    }

    private void assertComplete() {
        if (this.status == null) {
            throw new IllegalStateException("Task has not executed yet.");
        }
    }
}

