/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.auth;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JschAgentProxySessionFactory
extends JschConfigSessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(JschAgentProxySessionFactory.class);

    protected void configure(OpenSshConfig.Host hc, Session session) {
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        JSch jsch = super.getJSch(hc, fs);
        Connector con = this.determineConnector();
        if (con != null) {
            RemoteIdentityRepository remoteRepo = new RemoteIdentityRepository(con);
            if (!remoteRepo.getIdentities().isEmpty()) {
                logger.info("using agent proxy");
                jsch.setIdentityRepository((IdentityRepository)remoteRepo);
            } else {
                logger.info("not using agent proxy: no identities found");
            }
        }
        return jsch;
    }

    private Connector determineConnector() {
        List<AgentSelector> selectors = Arrays.asList(new SshAgentSelector(), new PageantSelector());
        for (AgentSelector selector : selectors) {
            Connector connector = selector.select();
            if (connector == null) continue;
            return connector;
        }
        logger.info("jsch agent proxy not available");
        return null;
    }

    private class PageantSelector
    implements AgentSelector {
        private PageantSelector() {
        }

        public Connector select() {
            try {
                if (PageantConnector.isConnectorAvailable()) {
                    logger.info("pageant available");
                    return new PageantConnector();
                }
                logger.info("pageant not available");
                return null;
            }
            catch (AgentProxyException e) {
                logger.info("pageant could not be configured: " + e.getMessage());
                logger.debug("pageant failure details", (Throwable)e);
                return null;
            }
        }
    }

    private class SshAgentSelector
    implements AgentSelector {
        private SshAgentSelector() {
        }

        public Connector select() {
            try {
                if (SSHAgentConnector.isConnectorAvailable()) {
                    logger.info("ssh-agent available");
                    JNAUSocketFactory usf = new JNAUSocketFactory();
                    return new SSHAgentConnector((USocketFactory)usf);
                }
                logger.info("ssh-agent not available");
                return null;
            }
            catch (AgentProxyException e) {
                logger.info("ssh-agent could not be configured: " + e.getMessage());
                logger.debug("ssh-agent failure details", (Throwable)e);
                return null;
            }
            catch (UnsatisfiedLinkError e) {
                logger.info("ssh-agent could not be configured: " + e.getMessage());
                logger.debug("ssh-agent failure details", (Throwable)e);
                return null;
            }
        }
    }

    private static interface AgentSelector {
        public Connector select();
    }
}

