/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ajoberstar.gradle.git.api.Branch;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.git.util.GitUtil;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitBranchList
extends GitBase {
    private BranchType type = BranchType.LOCAL;
    private List<Branch> branches;
    private Branch workingBranch;

    @TaskAction
    void branchList() {
        ListBranchCommand cmd = this.getGit().branchList();
        if (this.getBranchType() != null) {
            switch (this.getBranchType()) {
                case REMOTE: {
                    cmd.setListMode(ListBranchCommand.ListMode.REMOTE);
                    break;
                }
                case ALL: {
                    cmd.setListMode(ListBranchCommand.ListMode.ALL);
                    break;
                }
                case LOCAL: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Illegal branch type: " + (Object)((Object)this.getBranchType())));
                }
            }
        }
        try {
            Repository repo = this.getGit().getRepository();
            this.branches = new ArrayList<Branch>();
            for (Ref ref : cmd.call()) {
                this.branches.add(GitUtil.refToBranch(repo, ref));
            }
            this.workingBranch = GitUtil.gitNameToBranch(repo, repo.getFullBranch());
        }
        catch (IOException e) {
            throw new GradleException("Problem listing branches", (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem listing branches", (Throwable)e);
        }
    }

    public BranchType getBranchType() {
        return this.type;
    }

    public void setBranchType(BranchType type) {
        this.type = type;
    }

    public List<Branch> getBranches() {
        if (this.branches == null) {
            throw new IllegalStateException("Task has not executed yet.");
        }
        return this.branches;
    }

    public Branch getWorkingBranch() {
        if (this.workingBranch == null) {
            throw new IllegalStateException("Task has not executed yet.");
        }
        return this.workingBranch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BranchType {
        LOCAL,
        REMOTE,
        ALL;

    }
}

