/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import groovy.lang.Closure;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.PersonIdent;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

public class GitTag
extends GitBase {
    private Object tagName = null;
    private Object message = null;
    private boolean sign = false;
    private boolean force = false;
    private PersonIdent tagger = null;

    @TaskAction
    public void tag() {
        TagCommand cmd = this.getGit().tag();
        cmd.setName(this.getTagName());
        cmd.setMessage(this.getMessage());
        cmd.setSigned(this.getSign());
        cmd.setForceUpdate(this.getForce());
        if (this.tagger != null) {
            cmd.setTagger(this.getTagger());
        }
        try {
            cmd.call();
        }
        catch (ConcurrentRefUpdateException e) {
            throw new GradleException("Another process is accessing or updating the ref.", (Throwable)e);
        }
        catch (InvalidTagNameException e) {
            throw new GradleException("Invalid tag name: " + this.getTagName(), (Throwable)e);
        }
        catch (NoHeadException e) {
            throw new GradleException("Cannot tag without a HEAD revision.", (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem with tag.", (Throwable)e);
        }
    }

    @Input
    @Optional
    public String getMessage() {
        return ObjectUtil.unpackString(this.message);
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    @Input
    public String getTagName() {
        return ObjectUtil.unpackString(this.tagName);
    }

    public void setTagName(Object tagName) {
        this.tagName = tagName;
    }

    @Input
    public boolean getSign() {
        return this.sign;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    @Input
    public boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Input
    @Optional
    public PersonIdent getTagger() {
        return this.tagger;
    }

    public void setTagger(PersonIdent tagger) {
        this.tagger = tagger;
    }

    public void tagger(Closure config) {
        if (this.tagger == null) {
            this.tagger = new PersonIdent(this.getGit().getRepository());
        }
        ConfigureUtil.configure((Closure)config, (Object)this.tagger);
    }
}

