/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.auth;

import org.ajoberstar.gradle.git.auth.JschAgentProxyConfigCallback;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.awtui.AwtCredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;

public class TransportAuthUtil {
    private TransportAuthUtil() {
        throw new AssertionError((Object)"Cannot instantiate.");
    }

    public static void configure(TransportCommand command, AuthenticationSupported auth) {
        command.setCredentialsProvider(TransportAuthUtil.createCredentialsProvider(auth));
        command.setTransportConfigCallback((TransportConfigCallback)new JschAgentProxyConfigCallback());
    }

    private static CredentialsProvider createCredentialsProvider(AuthenticationSupported auth) {
        PasswordCredentials creds = auth.getCredentials();
        if (creds != null && creds.getUsername() != null && creds.getPassword() != null) {
            return new UsernamePasswordCredentialsProvider(creds.getUsername(), creds.getPassword());
        }
        return new AwtCredentialsProvider();
    }
}

