/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitClean
extends GitBase {
    private Set<Object> paths = null;

    @TaskAction
    public void reset() {
        CleanCommand cmd = this.getGit().clean();
        cmd.setPaths(this.getPaths());
        try {
            cmd.call();
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem with clean.", (Throwable)e);
        }
    }

    @Input
    public Set<String> getPaths() {
        if (this.paths == null) {
            return Collections.emptySet();
        }
        HashSet<String> cleanPaths = new HashSet<String>();
        for (Object path : this.paths) {
            cleanPaths.add(ObjectUtil.unpackString(path));
        }
        return cleanPaths;
    }

    public void paths(Object ... cleanPaths) {
        if (this.paths == null) {
            this.paths = new HashSet<Object>();
        }
        Collections.addAll(this.paths, cleanPaths);
    }

    public void paths(Iterable<? extends Object> cleanPaths) {
        if (this.paths == null) {
            this.paths = new HashSet<Object>();
        }
        for (Object object : cleanPaths) {
            this.paths.add(object);
        }
    }

    public void setPaths(Set<Object> cleanPaths) {
        this.paths = cleanPaths;
    }
}

