/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ajoberstar.gradle.git.auth.BasicPasswordCredentials;
import org.ajoberstar.gradle.git.auth.TransportAuthUtil;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitFetch
extends GitBase
implements AuthenticationSupported {
    private PasswordCredentials credentials = new BasicPasswordCredentials();
    private boolean dryRun = false;
    private boolean thin = true;
    private boolean remRefs = false;
    private boolean checkObjects = false;
    private Object remote = null;
    private Object fetchTags = null;
    private Collection<Object> refsToFetch = null;

    @TaskAction
    public void fetch() {
        FetchCommand cmd = this.getGit().fetch();
        TransportAuthUtil.configure((TransportCommand)cmd, this);
        cmd.setTagOpt(this.getTagOpt());
        cmd.setCheckFetchedObjects(this.getCheckFetchedObjects());
        cmd.setDryRun(this.getDryRun());
        cmd.setRefSpecs(this.getRefspecs());
        cmd.setRemote(this.getRemote());
        cmd.setRemoveDeletedRefs(this.getRemoveDeletedRefs());
        cmd.setThin(this.getThin());
        try {
            cmd.call();
        }
        catch (InvalidRemoteException e) {
            throw new GradleException("Invalid remote specified: " + this.getRemote(), (Throwable)e);
        }
        catch (TransportException e) {
            throw new GradleException("Problem with transport.", (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new GradleException("Problem with fetch.", (Throwable)e);
        }
    }

    @Input
    @Optional
    public PasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getCredentials());
    }

    public void setCredentials(PasswordCredentials credentials) {
        this.credentials = credentials;
    }

    @Input
    public String getRemote() {
        return this.remote == null ? "origin" : ObjectUtil.unpackString(this.remote);
    }

    public void setRemote(Object remote) {
        this.remote = remote;
    }

    @Input
    public boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Input
    public boolean getThin() {
        return this.thin;
    }

    public void setThin(boolean thin) {
        this.thin = thin;
    }

    @Input
    public boolean getRemoveDeletedRefs() {
        return this.remRefs;
    }

    public void setRemoveDeletedRefs(boolean remRefs) {
        this.remRefs = remRefs;
    }

    @Input
    public boolean getCheckFetchedObjects() {
        return this.checkObjects;
    }

    public void setCheckFetchedObjects(boolean checkObjects) {
        this.checkObjects = checkObjects;
    }

    @Input
    @Optional
    public List<RefSpec> getRefspecs() {
        if (this.refsToFetch == null) {
            return Collections.emptyList();
        }
        ArrayList<RefSpec> refspecs = new ArrayList<RefSpec>();
        for (Object branch : this.refsToFetch) {
            try {
                refspecs.add(new RefSpec(ObjectUtil.unpackString(branch)));
            }
            catch (IllegalArgumentException e) {
                throw new GradleException("Invalid refs specified", (Throwable)e);
            }
        }
        return refspecs;
    }

    public void refspecs(Object ... refs) {
        if (this.refsToFetch == null) {
            this.refsToFetch = new ArrayList<Object>();
        }
        Collections.addAll(this.refsToFetch, refs);
    }

    public void setRefspecs(List<? extends Object> refsToFetch) {
        this.refsToFetch = refsToFetch;
    }

    @Input
    @Optional
    public Object getFetchTags() {
        return this.fetchTags;
    }

    public void setFetchTags(Object fetchTags) {
        this.fetchTags = fetchTags;
    }

    private TagOpt getTagOpt() {
        String tagConfig = ObjectUtil.unpackString(this.getFetchTags());
        if (tagConfig == null) {
            return TagOpt.AUTO_FOLLOW;
        }
        if (tagConfig.equalsIgnoreCase("auto")) {
            return TagOpt.AUTO_FOLLOW;
        }
        if (tagConfig.equalsIgnoreCase("yes")) {
            return TagOpt.FETCH_TAGS;
        }
        if (tagConfig.equalsIgnoreCase("no")) {
            return TagOpt.NO_TAGS;
        }
        throw new GradleException("No valid tag option could be identified from the specified input: " + tagConfig);
    }
}

