/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.tasks;

import groovy.lang.Closure;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ajoberstar.gradle.git.auth.BasicPasswordCredentials;
import org.ajoberstar.gradle.git.auth.TransportAuthUtil;
import org.ajoberstar.gradle.git.tasks.GitBase;
import org.ajoberstar.gradle.util.ObjectUtil;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPush
extends GitBase
implements AuthenticationSupported {
    private PasswordCredentials credentials = new BasicPasswordCredentials();
    private Object remote = null;
    private List<String> namesOrSpecs;
    private boolean pushTags = false;
    private boolean pushAll = false;
    private boolean force = false;

    @TaskAction
    public void push() {
        PushCommand cmd = this.getGit().push();
        TransportAuthUtil.configure((TransportCommand)cmd, this);
        cmd.setRemote(this.getRemote());
        if (this.getNamesOrSpecs() != null) {
            for (String nameOrSpec : this.getNamesOrSpecs()) {
                cmd.add(nameOrSpec);
            }
        }
        if (this.isPushTags()) {
            cmd.setPushTags();
        }
        if (this.isPushAll()) {
            cmd.setPushAll();
        }
        cmd.setForce(this.isForce());
        try {
            cmd.call();
        }
        catch (Exception e) {
            throw new GradleException("Problem pushing to repository.", (Throwable)e);
        }
    }

    @Input
    @Optional
    public PasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getCredentials());
    }

    public void setCredentials(PasswordCredentials credentials) {
        this.credentials = credentials;
    }

    @Input
    public String getRemote() {
        return this.remote == null ? "origin" : ObjectUtil.unpackString(this.remote);
    }

    public void setRemote(Object remote) {
        this.remote = remote;
    }

    @Input
    @Optional
    public List<String> getNamesOrSpecs() {
        return this.namesOrSpecs;
    }

    public void setNamesOrSpecs(List<String> namesOrSpecs) {
        this.namesOrSpecs = namesOrSpecs;
    }

    public void namesOrSpecs(String ... namesOrSpecs) {
        if (this.namesOrSpecs == null) {
            this.namesOrSpecs = Arrays.asList(namesOrSpecs);
        } else {
            Collections.addAll(this.namesOrSpecs, namesOrSpecs);
        }
    }

    @Input
    public boolean isPushTags() {
        return this.pushTags;
    }

    public void setPushTags(boolean pushTags) {
        this.pushTags = pushTags;
    }

    @Input
    public boolean isPushAll() {
        return this.pushAll;
    }

    public void setPushAll(boolean pushAll) {
        this.pushAll = pushAll;
    }

    @Input
    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

