/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.stutter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.ajoberstar.gradle.stutter.StutterMatrix;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;

public class GenerateStutterLocks
extends DefaultTask {
    private RegularFileProperty outputFile;
    private SetProperty<StutterMatrix> matrices;
    private Property<Boolean> sparse;

    @Inject
    public GenerateStutterLocks(ObjectFactory objectFactory) {
        this.outputFile = objectFactory.fileProperty();
        this.matrices = objectFactory.setProperty(StutterMatrix.class);
        this.sparse = objectFactory.property(Boolean.class);
        this.getOutputs().upToDateWhen(t -> false);
    }

    @TaskAction
    public void generate() {
        Set<GradleVersion> allVersions = this.getAllVersions();
        Path lockFilePath = ((File)this.outputFile.getAsFile().get()).toPath();
        try (BufferedWriter writer = Files.newBufferedWriter(lockFilePath, new OpenOption[0]);){
            writer.write("# DO NOT MODIFY: Generated by Stutter plugin.");
            writer.newLine();
            for (StutterMatrix matrix : (Set)this.matrices.get()) {
                String gradleVersions = matrix.getGradleVersions().resolve(allVersions, (Boolean)this.sparse.get()).sorted().distinct().map(GradleVersion::getVersion).collect(Collectors.joining(","));
                writer.write(String.format("%s=%s", matrix.getName(), gradleVersions));
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Set<GradleVersion> getAllVersions() {
        try {
            URL serviceUrl = new URL("https://services.gradle.org/versions/all");
            JsonNode versions = (JsonNode)new ObjectMapper().readValue(serviceUrl, JsonNode.class);
            return StreamSupport.stream(versions.spliterator(), false).filter(node -> !node.get("broken").asBoolean()).filter(node -> {
                GradleVersion version = GradleVersion.version((String)node.get("version").asText());
                boolean finalVersion = version.equals(version.getBaseVersion());
                boolean rcVersion = !node.get("rcFor").asText().isEmpty();
                boolean milestoneVersion = !node.get("milestoneFor").asText().isEmpty();
                return finalVersion || rcVersion || milestoneVersion;
            }).map(node -> node.get("version").asText()).map(GradleVersion::version).peek(version -> this.getProject().getLogger().debug("Stutter found: " + version)).collect(Collectors.toSet());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Services url is invalid.", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Internal
    public SetProperty<StutterMatrix> getMatrices() {
        return this.matrices;
    }

    @Internal
    public Property<Boolean> getSparse() {
        return this.sparse;
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }
}

