/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.stutter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.util.GradleVersion;

public class StutterGradleVersions {
    private Set<GradleVersion> compatibleVersions = new HashSet<GradleVersion>();
    private Set<GradleVersion> incompatibleVersions = new HashSet<GradleVersion>();
    private List<Predicate<GradleVersion>> compatibleRanges = new ArrayList<Predicate<GradleVersion>>();

    public void compatibleRange(String startingInclusive) {
        GradleVersion start = GradleVersion.version((String)startingInclusive);
        this.compatibleRanges.add(version -> version.getBaseVersion().compareTo(start) >= 0);
    }

    public void compatibleRange(String startingInclusive, String endingExclusive) {
        GradleVersion end;
        GradleVersion start = GradleVersion.version((String)startingInclusive);
        if (start.compareTo(end = GradleVersion.version((String)endingExclusive)) >= 0) {
            throw new IllegalArgumentException("Starting version must be less than ending version: " + startingInclusive + " to " + endingExclusive);
        }
        this.compatibleRanges.add(version -> version.getBaseVersion().compareTo(start) >= 0 && version.getBaseVersion().compareTo(end) < 0);
    }

    public void incompatible(String ... versions) {
        Arrays.stream(versions).map(GradleVersion::version).forEach(this.incompatibleVersions::add);
    }

    public void compatible(String ... versions) {
        Arrays.stream(versions).map(GradleVersion::version).forEach(this.compatibleVersions::add);
    }

    Stream<GradleVersion> resolve(Set<GradleVersion> versions, boolean sparse) {
        Stream<GradleVersion> knownCompatibleExact = versions.stream().filter(this.compatibleVersions::contains);
        Stream<GradleVersion> knownCompatibleRange = versions.stream().filter(v -> this.compatibleRanges.stream().anyMatch(p -> p.test(v)));
        Stream<GradleVersion> knownCompatible = Stream.concat(knownCompatibleExact, knownCompatibleRange).filter(version -> !this.incompatibleVersions.contains(version));
        Stream<GradleVersion> knownCompatibleMinors = this.compatibleGradleMinors(knownCompatible);
        if (sparse) {
            return this.compatibleGradleSparse(knownCompatibleMinors);
        }
        return knownCompatibleMinors;
    }

    private Stream<GradleVersion> compatibleGradleMinors(Stream<GradleVersion> versions) {
        Function<GradleVersion, String> minorVersion = version -> {
            String[] parts = version.getBaseVersion().getVersion().split("\\.");
            if (parts.length < 2) {
                throw new IllegalArgumentException("Version doesn't contain a major and minor component: " + version);
            }
            return String.format("%s.%s", parts[0], parts[1]);
        };
        Function<List, Stream> toMax = vers -> {
            Optional max = vers.stream().max(Comparator.naturalOrder());
            Optional<GradleVersion> maxFinal = vers.stream().filter(ver -> ver.equals(ver.getBaseVersion())).max(Comparator.naturalOrder());
            return Stream.of(max, maxFinal).flatMap(Optional::stream);
        };
        Map<String, List<GradleVersion>> versionsByMinor = versions.collect(Collectors.groupingBy(minorVersion));
        return versionsByMinor.values().stream().flatMap(toMax);
    }

    private Stream<GradleVersion> compatibleGradleSparse(Stream<GradleVersion> versions) {
        Function<GradleVersion, String> majorVersion = version -> version.getVersion().substring(0, version.getVersion().indexOf(46));
        Function<List, Stream> toMinMax = vers -> {
            Optional min = vers.stream().min(Comparator.naturalOrder());
            Optional max = vers.stream().max(Comparator.naturalOrder());
            Optional<GradleVersion> maxFinal = vers.stream().filter(ver -> ver.equals(ver.getBaseVersion())).max(Comparator.naturalOrder());
            return Stream.of(min, max, maxFinal).flatMap(Optional::stream);
        };
        Map<String, List<GradleVersion>> versionsByMajor = versions.collect(Collectors.groupingBy(majorVersion));
        return versionsByMajor.values().stream().flatMap(toMinMax);
    }
}

