/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.stutter;

import javax.inject.Inject;
import org.ajoberstar.gradle.stutter.StutterGradleVersions;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class StutterMatrix
implements Named {
    private final String name;
    private final Property<JavaLauncher> javaLauncher;
    private final StutterGradleVersions gradleVersions;
    private final JavaToolchainService toolchain;

    @Inject
    public StutterMatrix(String name, ObjectFactory objectFactory, JavaToolchainService toolchain) {
        this.name = name;
        this.javaLauncher = objectFactory.property(JavaLauncher.class);
        this.gradleVersions = new StutterGradleVersions();
        this.toolchain = toolchain;
    }

    public String getName() {
        return this.name;
    }

    Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    public void javaToolchain(Action<? super JavaToolchainSpec> configureAction) {
        this.javaLauncher.set(this.toolchain.launcherFor(configureAction));
    }

    public StutterGradleVersions getGradleVersions() {
        return this.gradleVersions;
    }

    public void gradleVersions(Action<? super StutterGradleVersions> configureAction) {
        configureAction.execute((Object)this.gradleVersions);
    }
}

